/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import ocr.OC;

public class Style {
    private String name;
    private int maxCharacterHeight = 0;
    public List<OC> ocReference = new ArrayList<OC>();

    public Style(File file) {
        this.name = file.getName();
        File[] files = file.listFiles((dir, name) -> name.contains(".png"));
        if (files != null) {
            for (File f : files) {
                try {
                    BufferedImage img = ImageIO.read(f);
                    if (img == null) continue;
                    ArrayList<Point> pointList = new ArrayList<Point>();
                    for (int y = 0; y < img.getHeight(); ++y) {
                        for (int x = 0; x < img.getWidth(); ++x) {
                            if (img.getRGB(x, y) != Color.BLACK.getRGB()) continue;
                            pointList.add(new Point(x, y));
                        }
                    }
                    Point[] pointArray = pointList.toArray(new Point[pointList.size()]);
                    this.ocReference.add(new OC(f.getName().charAt(0), (int)pointArray[0].getX(), (int)pointArray[0].getY(), img.getWidth(), img.getHeight(), pointArray));
                    if (img.getHeight() <= this.maxCharacterHeight) continue;
                    this.maxCharacterHeight = img.getHeight();
                }
                catch (IOException e) {
                    System.out.println("There was an IOException trying to read file: " + f.getName());
                }
            }
        } else {
            System.out.println("No files were matching!");
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMaxCharacterHeight() {
        return this.maxCharacterHeight;
    }
}

