/*
 * Decompiled with CFR 0.152.
 */
package ocr;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import ocr.OC;
import ocr.Style;

public class OCR {
    private static Style textStyle = null;
    private static BufferedImage bufferedImage = null;
    private static Color textColor = new Color(0, 0, 0);
    private static int charSpacing = 4;
    private static Comparator<OC> xComparator = (oc1, oc2) -> oc1.getX() - oc2.getX();

    public static void setBufferedImage(BufferedImage image) {
        bufferedImage = image;
    }

    public static void setTextColor(Color color) {
        textColor = color;
    }

    public static void setStyle(Style style) {
        textStyle = style;
    }

    public static void setCharSpacing(int spacing) {
        charSpacing = spacing;
    }

    private static boolean comparePoints(OC o, int x, int y) {
        Object[] p = new Point[o.getPoints().length];
        try {
            int i = 0;
            for (int y3 = 0; y3 < o.getHeight(); ++y3) {
                for (int x3 = 0; x3 < o.getWidth(); ++x3) {
                    if (i > p.length) {
                        return false;
                    }
                    if (bufferedImage.getRGB(x + x3, y + y3) != textColor.getRGB()) continue;
                    p[i] = new Point(x3, y3);
                    ++i;
                }
            }
            return Arrays.equals(o.getPoints(), p);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static List<OC> findOpticalCharacters() {
        ArrayList<OC> opticalCharacters = new ArrayList<OC>();
        for (int y = 0; y < bufferedImage.getHeight(); ++y) {
            block3: for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                block4: for (OC o : OCR.textStyle.ocReference) {
                    try {
                        if (bufferedImage.getRGB(x + o.getX(), y + o.getY()) != textColor.getRGB()) continue;
                        for (int lr = 0; lr < o.getHeight(); ++lr) {
                            if (bufferedImage.getRGB(x - 1, y + lr) == textColor.getRGB() || bufferedImage.getRGB(x + o.getWidth(), y + lr) == textColor.getRGB()) continue block4;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        continue;
                    }
                    if (!OCR.comparePoints(o, x, y)) continue;
                    OC oc = new OC(o.getCharacter(), x, y, o.getWidth(), o.getHeight(), null);
                    opticalCharacters.add(oc);
                    x += oc.getWidth();
                    continue block3;
                }
            }
        }
        return opticalCharacters;
    }

    private static String generateTextLine(List<OC> opticalCharactersInLine) {
        Collections.sort(opticalCharactersInLine, xComparator);
        ListIterator<OC> i = opticalCharactersInLine.listIterator();
        int currentX = -1;
        StringBuilder b = new StringBuilder();
        while (i.hasNext()) {
            OC oc = i.next();
            if (currentX > -1 && oc.getX() - currentX > charSpacing) {
                b.append(" ");
            }
            b.append(oc.getCharacter());
            currentX = oc.getX() + oc.getWidth();
        }
        return b.toString();
    }

    public static List<String> generateTextBody(List<OC> opticalCharacters) {
        if (!opticalCharacters.isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>();
            while (!opticalCharacters.isEmpty()) {
                OC opticalCharacter = opticalCharacters.get(0);
                int minHeight = opticalCharacter.getY() + (opticalCharacter.getHeight() - textStyle.getMaxCharacterHeight());
                int maxHeight = opticalCharacter.getY() + opticalCharacter.getHeight();
                List<OC> line = opticalCharacters.stream().filter(s -> s.getY() >= minHeight && s.getY() <= maxHeight).collect(Collectors.toList());
                opticalCharacters.removeAll(line);
                lines.add(OCR.generateTextLine(line));
            }
            return lines;
        }
        return null;
    }
}

