/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileNameExtensionFilter;
import ocr.OCR;
import ocr.Style;

public class Main
extends JFrame {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 250;
    private static final int RGB_X = 20;
    private static final int RGB_Y = 20;
    String[] fonts = new String[]{"None"};
    File ocrImage = null;
    private Collection<Style> styles = new ArrayList<Style>();
    private static String status = "Idle";
    private static JLabel statusLabel = new JLabel("Status: " + status);
    JComboBox<String> fontBox = new JComboBox<String>(new DefaultComboBoxModel<String>(this.fonts));

    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        this.setTitle("PixelOCR");
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setSize(400, 250);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(400, 250));
        this.add(tabbedPane);
        SpringLayout layout = new SpringLayout();
        JPanel panel1 = new JPanel(false);
        tabbedPane.addTab("Main", null, panel1);
        panel1.setLayout(layout);
        JTextField textRField = new JTextField(4);
        textRField.setText("0");
        this.addC(textRField, 20, 20, panel1, layout);
        JLabel textRLabel = new JLabel("R:");
        this.addC(textRLabel, textRField.getX(), textRField.getY() - 15, panel1, layout);
        JTextField textGField = new JTextField(4);
        textGField.setText("0");
        this.addC(textGField, textRField.getX() + textRField.getWidth() + 50, textRField.getY(), panel1, layout);
        JLabel textGLabel = new JLabel("G:");
        this.addC(textGLabel, textGField.getX(), textGField.getY() - 15, panel1, layout);
        JTextField textBField = new JTextField(4);
        textBField.setText("0");
        this.addC(textBField, textGField.getX() + textGField.getWidth() + 50, textRField.getY(), panel1, layout);
        JLabel textBLabel = new JLabel("B:");
        this.addC(textBLabel, textBField.getX(), textBField.getY() - 15, panel1, layout);
        JLabel maxSpaceLabel = new JLabel("Max character spacing:");
        this.addC(maxSpaceLabel, textBLabel.getX() + 75, textBLabel.getY(), panel1, layout);
        JTextField spaceField = new JTextField(3);
        spaceField.setText("4");
        this.addC(spaceField, maxSpaceLabel.getX(), maxSpaceLabel.getY() + 15, panel1, layout);
        this.addC(this.fontBox, 20, 75, panel1, layout);
        this.fontBox.setPreferredSize(new Dimension(135, 20));
        JLabel fontLabel = new JLabel("Font Packs: " + System.getProperty("user.dir") + "\\Fonts");
        this.addC(fontLabel, this.fontBox.getX(), this.fontBox.getY() - 15, panel1, layout);
        JButton reloadFontButton = new JButton("Reload");
        this.addC(reloadFontButton, this.fontBox.getX() + 150, this.fontBox.getY(), panel1, layout);
        JButton imageLocButton = new JButton("Select image");
        this.addC(imageLocButton, 20, 130, panel1, layout);
        JLabel imageLocLabel = new JLabel("OCR Image: <Not Selected>");
        this.addC(imageLocLabel, imageLocButton.getX(), imageLocButton.getY() - 15, panel1, layout);
        JButton startButton = new JButton("Start");
        this.addC(startButton, 150, 190, panel1, layout);
        this.addC(statusLabel, 20, startButton.getY() - 20, panel1, layout);
        JPanel panel2 = new JPanel(false);
        tabbedPane.addTab("About", null, panel2);
        panel2.setLayout(layout);
        JLabel aboutLabel = new JLabel("<html>Written by: Aleksander Krimsky<br>Website: www.krimsky.net<br>Version: 1.0.0<br>Created: 23 April 2015<br><br>PixelOCR is a simple buffered image pixel-by-pixel scanner that<br>can be easily trained through the use of user-made font packs. For<br>more information about this project and in-depth instructions,<br>please visit the website listed above.</html>");
        this.addC(aboutLabel, 10, 35, panel2, layout);
        startButton.addActionListener(e -> {
            BufferedImage img = null;
            try {
                img = ImageIO.read(this.ocrImage);
            }
            catch (Exception IOE) {
                Main.setStatus("Selected file was unable to be read");
            }
            if (img != null) {
                Style getStyle = this.getStyleForName(this.fontBox.getSelectedItem().toString());
                if (getStyle != null) {
                    OCR.setStyle(getStyle);
                    OCR.setBufferedImage(img);
                    try {
                        int r = Integer.parseInt(textRField.getText());
                        int g = Integer.parseInt(textGField.getText());
                        int b = Integer.parseInt(textBField.getText());
                        OCR.setTextColor(new Color(r, g, b));
                        OCR.setCharSpacing(Integer.parseInt(spaceField.getText()));
                    }
                    catch (NumberFormatException NFE) {
                        System.out.println("User inputted incorrect values, using default settings");
                    }
                    List<String> words = OCR.generateTextBody(OCR.findOpticalCharacters());
                    if (words != null) {
                        try {
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(System.getProperty("user.dir") + "\\result.txt"))));
                            for (String s : words) {
                                writer.write(s);
                                writer.newLine();
                            }
                            writer.close();
                        }
                        catch (IOException ioe) {
                            Main.setStatus("Failed to export result.txt");
                        }
                        Main.setStatus("Scan complete, exported results to result.txt");
                    } else {
                        Main.setStatus("Scan complete, no words found");
                    }
                } else {
                    Main.setStatus("No styles were loaded/selected");
                }
            }
        });
        reloadFontButton.addActionListener(e -> this.loadFonts());
        imageLocButton.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("PNG Images", "png"));
            int returnVal = chooser.showOpenDialog(this.getParent());
            if (returnVal == 0) {
                this.ocrImage = chooser.getSelectedFile();
                imageLocLabel.setText("OCR Image: " + chooser.getSelectedFile().getPath());
            }
        });
        this.loadFonts();
        this.setVisible(true);
        this.pack();
    }

    private Style getStyleForName(String name) {
        Collection s1 = this.styles.stream().filter(s -> s.getName().equals(name)).collect(Collectors.toList());
        return s1.isEmpty() ? null : (Style)s1.iterator().next();
    }

    public static void setStatus(String status) {
        statusLabel.setText("Status: " + status);
    }

    public void loadFonts() {
        File file = new File(System.getProperty("user.dir") + "\\Fonts");
        if (file.exists()) {
            File[] files = file.listFiles((dir, name) -> file.isDirectory());
            if (files.length > 0) {
                this.fonts = new String[files.length];
                for (int i = 0; i < this.fonts.length; ++i) {
                    Style s = new Style(files[i]);
                    this.styles.add(s);
                    this.fonts[i] = s.getName();
                }
                Main.setStatus("Found " + files.length + " font pack(s)");
                this.fontBox.setModel(new DefaultComboBoxModel<String>(this.fonts));
                this.fontBox.setEnabled(true);
            } else {
                this.fontBox.setModel(new DefaultComboBoxModel<String>(new String[]{"null"}));
                this.fontBox.setEnabled(false);
            }
        } else {
            Main.setStatus("Missing \"Fonts\" pack folder");
            this.fontBox.setModel(new DefaultComboBoxModel<String>(new String[]{"null"}));
            this.fontBox.setEnabled(false);
        }
    }

    void addC(JComponent jComponent, int x, int y, JComponent panel, SpringLayout layout) {
        panel.add(jComponent);
        jComponent.setLocation(x, y);
        layout.putConstraint("West", (Component)jComponent, jComponent.getX(), "West", (Component)panel);
        layout.putConstraint("North", (Component)jComponent, jComponent.getY(), "North", (Component)panel);
    }
}

