/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class Settings
extends JFrame {
    public JLabel removeLabel = new JLabel("Line id:");
    public JTextField removeField = new JTextField(3);
    public JLabel slopeLabel = new JLabel("Slope:");
    public JTextField slopeField = new JTextField(12);
    public JLabel baseLabel = new JLabel("Base:");
    public JTextField baseField = new JTextField(9);
    public JButton addButton = new JButton("Add Line");
    public JButton removeButton = new JButton("Remove Line");
    public JButton loadButton = new JButton("Load CSV");
    public JButton clearButton = new JButton("Clear All");
    public JCheckBox originCheckbox = new JCheckBox("Show Origin");
    public JCheckBox interCheckbox = new JCheckBox("Show Intersections");
    public JComboBox resolutionBox = new JComboBox<String>(new String[]{"1920x1080", "1000x1000", "1024x768", "800x600", "500x500"});
    Font font = new Font("SansSerif", 0, 11);
    Visual visual = new Visual();

    public static void main(String[] args) {
        new Settings();
    }

    public Settings() {
        this.setTitle("Line Visualizer - www.krimsky.net");
        this.setPreferredSize(new Dimension(400, 240));
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.addComponent(this.loadButton, 5, 15, layout, this.font);
        this.loadButton.setPreferredSize(new Dimension(100, 20));
        this.loadButton.setFocusPainted(false);
        this.loadButton.addActionListener(ActionListener2 -> {
            JFileChooser fc = new JFileChooser();
            fc.setMultiSelectionEnabled(false);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    ArrayList<Line> lines = new ArrayList<Line>();
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            String[] split = line.split(",");
                            if (split.length != 2) {
                                JOptionPane.showMessageDialog(null, "The following line is not valid: \n" + line + " \n Must be in format: \"slope,base\"", "Line Visualizer - Invalid line", 1);
                                break;
                            }
                            try {
                                double slope = Double.parseDouble(split[0]);
                                double base = Double.parseDouble(split[1]);
                                lines.add(new Line(slope, base));
                            }
                            catch (NumberFormatException e) {
                                JOptionPane.showMessageDialog(null, "Invalid valid floating point number for the base and/or slope :\n " + line, "Line Visualizer - NumberFormatException", 1);
                                break;
                            }
                        }
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(null, "Failed to load file!", "Line Visualizer - IOException", 1);
                    }
                    for (Line l : lines) {
                        SPanel.addLine(l.m, l.b);
                    }
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(null, "Selected file not found!", "Line Visualizer - FileNotFoundException", 1);
                }
            }
            System.out.println(returnVal);
        });
        this.addComponent(this.clearButton, 160, 15, layout, this.font);
        this.clearButton.setPreferredSize(new Dimension(100, 20));
        this.clearButton.setFocusPainted(false);
        this.clearButton.addActionListener(ActionListener2 -> SPanel.clearAll());
        this.addComponent(this.slopeLabel, 5, 65, layout, this.font);
        this.addComponent(this.slopeField, 40, 65, layout, this.font);
        this.addComponent(this.baseLabel, 150, 65, layout, this.font);
        this.addComponent(this.baseField, 185, 65, layout, this.font);
        this.addComponent(this.addButton, 290, 65, layout, this.font);
        this.addButton.setPreferredSize(new Dimension(80, 20));
        this.addButton.setFocusPainted(false);
        this.addButton.addActionListener(ActionListener2 -> {
            try {
                double slope = Double.parseDouble(this.slopeField.getText());
                double base = Double.parseDouble(this.baseField.getText());
                SPanel.addLine(slope, base);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Please enter a valid floating point number for the base and/or slope", "Line Visualizer - NumberFormatException", 1);
            }
        });
        this.addComponent(this.removeLabel, 5, 115, layout, this.font);
        this.addComponent(this.removeField, 45, 115, layout, this.font);
        this.addComponent(this.removeButton, 90, 115, layout, this.font);
        this.removeButton.setPreferredSize(new Dimension(100, 20));
        this.removeButton.setFocusPainted(false);
        this.removeButton.addActionListener(ActionListener2 -> {
            try {
                int id = Integer.parseInt(this.removeField.getText());
                SPanel.removeLine(id);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Please enter a valid line id (integer)", "Line Visualizer - NumberFormatException", 1);
            }
        });
        this.addComponent(this.originCheckbox, 5, 165, layout, this.font);
        this.originCheckbox.setFocusPainted(false);
        this.originCheckbox.addActionListener(ActionListener2 -> SPanel.setPaintOrigin(this.originCheckbox.isSelected()));
        this.addComponent(this.interCheckbox, 125, 165, layout, this.font);
        this.interCheckbox.setFocusPainted(false);
        this.interCheckbox.addActionListener(ActionListener2 -> SPanel.setPaintIntersections(this.interCheckbox.isSelected()));
        this.addComponent(this.resolutionBox, 275, 165, layout, this.font);
        this.resolutionBox.setFocusable(false);
        this.resolutionBox.setSelectedIndex(2);
        this.resolutionBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch (e.getItem().toString()) {
                        case "1920x1080": {
                            System.out.println("a");
                            Settings.this.visual.setResolution(1920, 1080);
                            break;
                        }
                        case "1000x1000": {
                            Settings.this.visual.setResolution(1000, 1000);
                            break;
                        }
                        case "1024x768": {
                            Settings.this.visual.setResolution(1024, 768);
                            break;
                        }
                        case "800x600": {
                            Settings.this.visual.setResolution(800, 600);
                            break;
                        }
                        case "500x500": {
                            Settings.this.visual.setResolution(500, 500);
                        }
                    }
                }
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private void addComponent(JComponent jComponent, int x, int y, SpringLayout layout, Font font) {
        jComponent.setFont(font);
        this.add(jComponent);
        jComponent.setLocation(x, y);
        layout.putConstraint("West", (Component)jComponent, x, "West", (Component)this);
        layout.putConstraint("North", (Component)jComponent, y, "North", (Component)this);
    }
}

