/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;

public class SPanel
extends JPanel {
    static Line[] lines = new Line[1024];
    static Color[] colors = new Color[1024];
    static List<Intersection> intersections = new ArrayList<Intersection>();
    private static boolean paintOrigin = false;
    private static boolean paintIntersections = false;
    int mouseX;
    int mouseY;

    public static void addLine(double slope, double base) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] != null) continue;
            Line line = new Line(i, slope, base);
            for (int j = 0; j < lines.length; ++j) {
                if (lines[j] == null) continue;
                intersections.add(new Intersection(i, j, line.getIntersection(lines[j])));
            }
            SPanel.lines[i] = line;
            break;
        }
    }

    public static void removeLine(int id) {
        ArrayList<Intersection> removeList = new ArrayList<Intersection>();
        for (Intersection i : intersections) {
            if (!i.hasId(id)) continue;
            removeList.add(i);
        }
        intersections.removeAll(removeList);
        SPanel.lines[id] = null;
    }

    public static void setPaintOrigin(boolean value) {
        paintOrigin = value;
    }

    public static void setPaintIntersections(boolean value) {
        paintIntersections = value;
    }

    public static void clearAll() {
        lines = new Line[1024];
        intersections = new ArrayList<Intersection>();
    }

    public SPanel() {
        BAdapter b = new BAdapter();
        this.addMouseListener(b);
        this.addMouseMotionListener(b);
        Random r = new Random();
        for (int i = 0; i < colors.length; ++i) {
            SPanel.colors[i] = new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255));
        }
        this.setFocusable(true);
        this.setBackground(Color.BLACK);
        this.setDoubleBuffered(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.drawString(this.mouseX + ", " + this.mouseY, 0, 10);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            g.setColor(colors[i]);
            g.drawString("Line: " + i, 0, 30 + i * 20);
            g.drawLine(0, (int)(lines[i].getY(-Visual.WIDTH / 2) * -1.0) + Visual.HEIGHT / 2, Visual.WIDTH, (int)(lines[i].getY(Visual.WIDTH / 2) * -1.0) + Visual.HEIGHT / 2);
        }
        if (paintIntersections) {
            for (Intersection i : intersections) {
                g.setColor(Color.RED);
                g.drawRect(i.point.x - 1 + Visual.WIDTH / 2, (i.point.y - 1) * -1 + Visual.HEIGHT / 2 - 3, 3, 3);
            }
        }
        if (paintOrigin) {
            g.setColor(Color.GRAY);
            g.drawLine(Visual.WIDTH / 2, 0, Visual.WIDTH / 2, Visual.HEIGHT);
            g.drawLine(0, Visual.HEIGHT / 2, Visual.WIDTH, Visual.HEIGHT / 2);
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    private class BAdapter
    extends MouseAdapter {
        private BAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SPanel.this.mouseX = e.getX() - 500;
            SPanel.this.mouseY = (e.getY() - 500) * -1;
            SPanel.this.repaint();
        }
    }
}

