/*
 * Decompiled with CFR 0.152.
 */
package session;

import game.SaveLoad;
import server.SocketHandler;
import session.Player;

public class SessionLoop
implements Runnable {
    private SocketHandler player1;
    private SocketHandler player2;
    private boolean inGame = false;

    public SessionLoop(SocketHandler p1, SocketHandler p2) {
        this.player1 = p1;
        this.player2 = p2;
    }

    @Override
    public void run() {
        if (this.player1.getPlayer().getStatus().equals((Object)Player.Status.DISCONNECTED)) {
            this.player2.sendPacketToClient("OPP_DC");
            Thread.currentThread().interrupt();
            return;
        }
        if (this.player2.getPlayer().getStatus().equals((Object)Player.Status.DISCONNECTED)) {
            this.player1.sendPacketToClient("OPP_DC");
            Thread.currentThread().interrupt();
            return;
        }
        if (this.player1.getPlayer().getStatus().equals((Object)Player.Status.GAME_OVER) || this.player2.getPlayer().getStatus().equals((Object)Player.Status.GAME_OVER)) {
            System.out.println("Game over");
            Thread.currentThread().interrupt();
            return;
        }
        if (this.player1.getPlayer().getStatus().equals((Object)Player.Status.IN_GAME) && this.player2.getPlayer().getStatus().equals((Object)Player.Status.IN_GAME)) {
            this.gameLoop();
        }
        if (this.player1.getPlayer().getStatus().equals((Object)Player.Status.MAIN_MENU)) {
            this.player1.sendPacketToClient("INSETUP");
        }
        if (this.player2.getPlayer().getStatus().equals((Object)Player.Status.MAIN_MENU)) {
            this.player2.sendPacketToClient("INSETUP");
        }
        if (this.player1.getPlayer().getStatus().equals((Object)Player.Status.READY) && this.player2.getPlayer().getStatus().equals((Object)Player.Status.READY) && !this.inGame) {
            this.player1.sendPacketToClient("GIVINGPIECES." + SaveLoad.getPiecesAsString(this.player2.getPlayer().getPlayerPieces()));
            this.player2.sendPacketToClient("GIVINGPIECES." + SaveLoad.getPiecesAsString(this.player1.getPlayer().getPlayerPieces()));
            this.player1.sendPacketToClient("INGAME");
            this.player2.sendPacketToClient("INGAME");
            this.player1.getPlayer().setTurn(true);
            this.player1.sendPacketToClient("YOURTURN");
            this.player2.sendPacketToClient("THEIRTURN");
            this.inGame = true;
        }
    }

    public void gameLoop() {
        this.player1.sendPacketToClient("UPDATE_ENEMY." + SaveLoad.getPiecesAsString(this.player2.getPlayer().getPlayerPieces()));
        this.player2.sendPacketToClient("UPDATE_ENEMY." + SaveLoad.getPiecesAsString(this.player1.getPlayer().getPlayerPieces()));
        if (this.player1.getPlayer().isTurn()) {
            this.player1.sendPacketToClient("SEND_BOARD");
            this.player1.sendPacketToClient("YOURTURN");
            this.player2.sendPacketToClient("THEIRTURN");
        } else {
            this.player2.sendPacketToClient("SEND_BOARD");
            this.player1.sendPacketToClient("THEIRTURN");
            this.player2.sendPacketToClient("YOURTURN");
        }
    }
}

