/*
 * Decompiled with CFR 0.152.
 */
package session;

import game.Piece;
import game.SaveLoad;
import java.util.List;

public class Player {
    private List<Piece> pieces;
    private List<Piece> nonModifiedPieces;
    private List<Piece.PieceType> capturedPieces;
    private String clientAddress;
    private Status playerStatus = Status.MAIN_MENU;
    private boolean isTurn = false;

    public void addCapturedPiece(Piece.PieceType p) {
        this.capturedPieces.add(p);
    }

    public Piece getPiece(int x, int y) {
        System.out.println("size of pieces : " + this.pieces.size());
        for (int i = 0; i < this.pieces.size(); ++i) {
            Piece k = this.pieces.get(i);
            if (k.getPosition().x != x || k.getPosition().y != y) continue;
            return k;
        }
        return new Piece(Piece.PieceType.EMPTY);
    }

    public void setClientAddress(String s) {
        this.clientAddress = s;
    }

    public String getAddress() {
        return this.clientAddress;
    }

    public List<Piece> getPlayerPieces() {
        return this.pieces;
    }

    public List<Piece> getOriginalPieces() {
        return this.nonModifiedPieces;
    }

    public void setPlayerPieces(String s) {
        this.nonModifiedPieces = SaveLoad.convertPieces(s);
        this.pieces = SaveLoad.convertPiecesWithFlip(s);
    }

    public void removePiece(Piece p) {
        Piece k = p.clone();
        System.out.println("Removing piece on network at (" + k.getColumn() + ", " + k.getRow() + ") and size: " + this.pieces.size() + " and type: " + (Object)((Object)k.getPieceType()));
        this.pieces.remove(k);
        System.out.println("size: " + this.pieces.size());
    }

    public void setStatus(Status p) {
        this.playerStatus = p;
    }

    public Status getStatus() {
        return this.playerStatus;
    }

    public void printPieces() {
        System.out.println("PLAYER PIECES: " + this.pieces);
    }

    public void setTurn(boolean b) {
        this.isTurn = b;
    }

    public boolean isTurn() {
        return this.isTurn;
    }

    public static enum Status {
        MAIN_MENU,
        SETUP,
        READY,
        IN_GAME,
        GAME_OVER,
        DISCONNECTED;

    }
}

