/*
 * Decompiled with CFR 0.152.
 */
package session;

import java.util.ArrayList;
import session.GameSession;
import session.Player;

public class MultiplayerQueue {
    public ArrayList<Player> playerQueue = null;
    public ArrayList<GameSession> currentGames = null;

    public MultiplayerQueue() {
        System.out.println("Initalizing player queue...");
        this.playerQueue = new ArrayList();
        this.currentGames = new ArrayList();
    }

    public void addPlayer(String s) {
        Player m = new Player();
        m.setClientAddress(s);
        this.playerQueue.add(m);
        System.out.println("Added player to queue, queue count is now: " + this.playerQueue.size());
    }

    public void removePlayer(Player p) {
        this.playerQueue.remove(p);
    }

    public void removeGame(int index) {
        this.currentGames.remove(index);
    }

    public ArrayList<GameSession> getGames() {
        return this.currentGames;
    }

    public ArrayList<Player> getPlayers() {
        return this.playerQueue;
    }

    public Player getPlayerByAddress(String s) {
        for (int i = 0; i < this.playerQueue.size(); ++i) {
            Player a = this.playerQueue.get(i);
            if (!a.getAddress().equals(s)) continue;
            return a;
        }
        return null;
    }

    public GameSession checkForMatch() {
        if (this.playerQueue.size() > 1) {
            Player a = this.playerQueue.get(0);
            Player b = this.playerQueue.get(1);
            this.removePlayer(a);
            this.removePlayer(b);
            GameSession gs = new GameSession(a, b, this.currentGames.size() + 1);
            this.currentGames.add(gs);
            System.out.println("Players A and B are in a match! ");
            return gs;
        }
        return null;
    }
}

