/*
 * Decompiled with CFR 0.152.
 */
package server;

import game.Piece;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import server.Server;
import session.Player;

public class SocketHandler
implements Runnable {
    public boolean DEBUG = true;
    public Socket socket;
    public int id = 0;
    public Server hostServer;
    public String forcedPacket = "";
    public String clientsAddress = "";
    public Player clientsPlayer = null;
    public Player opponentPlayer = null;
    public List<Piece> boardPieces = new ArrayList<Piece>();

    public SocketHandler(Socket uniqueClient, int clientId, Server s, Player p, Player p2) {
        this.socket = uniqueClient;
        this.id = clientId;
        this.hostServer = s;
        this.clientsPlayer = p;
        this.opponentPlayer = p2;
    }

    public void debug(String s) {
        if (this.DEBUG) {
            String timeStamp = new SimpleDateFormat("hh:mm:ss").format(new Date());
            System.out.println("\t[CLIENTID:" + this.id + "/" + timeStamp + "]: " + s);
        }
    }

    public void setOpponent(Player p) {
        this.opponentPlayer = p;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void run() {
        InputStream in = null;
        DataInputStream dIn = null;
        try {
            in = this.socket.getInputStream();
            dIn = new DataInputStream(in);
            this.debug("New client connected");
            this.sendPacketToClient("Welcome to the server!");
            this.clientsAddress = this.socket.getRemoteSocketAddress().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            if (this.socket.isClosed() || !this.socket.isConnected()) {
                this.hostServer.decrementClientCount(this.clientsAddress);
                return;
            }
            if (this.socket == null) {
                return;
            }
            try {
                String packet;
                String response;
                if (dIn == null || !(response = this.handlePacket(packet = dIn.readUTF())).equals("Closing connection...")) continue;
                this.hostServer.decrementClientCount(this.getAddress());
                this.socket.close();
                return;
            }
            catch (SocketException e) {
                this.hostServer.decrementClientCount(this.getAddress());
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void sendPacketToClient(String s) {
        if (this.socket.isClosed() || !this.socket.isConnected()) {
            return;
        }
        if (this.socket == null) {
            return;
        }
        DataOutputStream dOut = null;
        try {
            dOut = new DataOutputStream(this.socket.getOutputStream());
            if (dOut != null) {
                dOut.writeUTF(s);
                dOut.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Player getPlayer() {
        return this.clientsPlayer;
    }

    public String getAddress() {
        if (this.socket == null) {
            return "Invalid address";
        }
        return this.socket.getRemoteSocketAddress().toString();
    }

    public String handlePacket(String s) {
        System.out.println(s);
        String n = "";
        if (s.startsWith("SENDPIECES")) {
            n = "Set player pieces";
            s = s.substring("SENDPIECES".length() + 1, s.length());
            this.clientsPlayer.setPlayerPieces(s);
            if (!this.clientsPlayer.getStatus().equals((Object)Player.Status.IN_GAME)) {
                this.clientsPlayer.setStatus(Player.Status.READY);
            }
            return n;
        }
        if (s.startsWith("GIVINGPIECES")) {
            n = "Setting our pieces";
            s = s.substring("GIVINGPIECES".length() + 1, s.length());
            this.clientsPlayer.setPlayerPieces(s);
            return n;
        }
        if (s.startsWith("UPDATE_ENEMY")) {
            n = "Setting enemy pieces";
            s = s.substring("UPDATE_ENEMY".length() + 1, s.length());
            for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                SocketHandler socketHandler = entry.getKey();
                SocketHandler s2 = entry.getValue();
                if (socketHandler.getPlayer().getAddress().equals(this.clientsAddress)) {
                    s2.getPlayer().setPlayerPieces(s);
                    break;
                }
                if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                socketHandler.getPlayer().setPlayerPieces(s);
                break;
            }
            return n;
        }
        if (s.startsWith("UPDATE_LOCAL")) {
            n = "Setting local pieces";
            s = s.substring("UPDATE_LOCAL".length() + 1, s.length());
            for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                SocketHandler socketHandler = entry.getKey();
                SocketHandler s2 = entry.getValue();
                if (socketHandler.getPlayer().getAddress().equals(this.clientsAddress)) {
                    socketHandler.getPlayer().setPlayerPieces(s);
                    break;
                }
                if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                s2.getPlayer().setPlayerPieces(s);
                break;
            }
            return n;
        }
        if (s.startsWith("SEND_CAPTURED")) {
            System.out.println("attempting to add captured: " + s);
            s = s.substring("SEND_CAPTURED".length() + 1, s.length());
            Enum cp = null;
            for (Piece.PieceType type : Piece.PieceType.values()) {
                if (!s.equals(type.name())) continue;
                cp = type;
                break;
            }
            if (cp != null) {
                System.out.println("adding captured piece to server: " + cp.toString());
                for (Map.Entry entry : this.hostServer.getPairedClients().entrySet()) {
                    SocketHandler s1 = (SocketHandler)entry.getKey();
                    SocketHandler s2 = (SocketHandler)entry.getValue();
                    if (s1.getPlayer().getAddress().equals(this.clientsAddress)) {
                        s2.getPlayer().addCapturedPiece((Piece.PieceType)cp);
                        s2.sendPacketToClient("SEND_CAPTURED." + cp.toString());
                        break;
                    }
                    if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                    s1.getPlayer().addCapturedPiece((Piece.PieceType)cp);
                    s1.sendPacketToClient("SEND_CAPTURED." + cp.toString());
                    break;
                }
            }
            return "Sent";
        }
        if (s.startsWith("REMOVE_PIECE")) {
            s = s.substring("REMOVE_PIECE".length() + 1, s.length());
            System.out.println("attempting to remove: " + s);
            if (s.length() == 3) {
                System.out.println("fuck this");
                String rx = Character.toString(s.charAt(0));
                String ry = Character.toString(s.charAt(2));
                int n2 = Integer.parseInt(rx);
                int y = Integer.parseInt(ry);
                System.out.println("Removing piece (" + n2 + ", " + y + ")");
                for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                    Piece pp1;
                    int i;
                    SocketHandler s1 = entry.getKey();
                    SocketHandler s2 = entry.getValue();
                    if (s1.getPlayer().getAddress().equals(this.clientsAddress)) {
                        Piece p4 = s2.getPlayer().getPiece(n2, y);
                        for (int i2 = 0; i2 <= 7; ++i2) {
                            Piece pp12 = s1.getPlayer().getPiece(n2, y);
                            System.out.println("aS1 Piece at (" + n2 + ", " + i2 + ") = " + (Object)((Object)pp12.getPieceType()));
                        }
                        for (int i2 = 0; i2 <= 7; ++i2) {
                            Piece pp12 = s2.getPlayer().getPiece(n2, i2);
                            System.out.println("aS2 Piece at (" + n2 + ", " + i2 + ") = " + (Object)((Object)pp12.getPieceType()));
                        }
                        s2.getPlayer().removePiece(p4);
                        System.out.println("s1 size: " + s1.getPlayer().getPlayerPieces().size());
                        System.out.println("s2 size: " + s2.getPlayer().getPlayerPieces().size());
                        s2.sendPacketToClient("REMOVE_LOCAL_PIECE." + p4.getColumn() + "." + (7 - p4.getRow()));
                        break;
                    }
                    if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                    Piece p4 = s1.getPlayer().getPiece(n2, y);
                    for (i = 0; i <= 7; ++i) {
                        pp1 = s1.getPlayer().getPiece(n2, y);
                        System.out.println("bS1 Piece at (" + n2 + ", " + i + ") = " + (Object)((Object)pp1.getPieceType()));
                    }
                    for (i = 0; i <= 7; ++i) {
                        pp1 = s2.getPlayer().getPiece(n2, i);
                        System.out.println("bS2 Piece at (" + n2 + ", " + i + ") = " + (Object)((Object)pp1.getPieceType()));
                    }
                    s1.getPlayer().removePiece(p4);
                    System.out.println("s1 size: " + s1.getPlayer().getPlayerPieces().size());
                    System.out.println("s2 size: " + s2.getPlayer().getPlayerPieces().size());
                    s1.sendPacketToClient("REMOVE_LOCAL_PIECE." + p4.getColumn() + "." + (7 - p4.getRow()));
                    break;
                }
            }
            n = "Couldn't find piece";
            return n;
        }
        block15 : switch (s) {
            case "PING": {
                n = "PONG";
                break;
            }
            case "REQUESTID": {
                n = Integer.toString(this.id);
                break;
            }
            case "REQUESTADDRESS": {
                n = this.socket.getLocalSocketAddress().toString();
                break;
            }
            case "DESTROY": {
                n = "Closing connection...";
                break;
            }
            case "QUEUEPLAYER": {
                n = "Adding client to matchmaking...";
                this.hostServer.getMultiplayerQueue().addPlayer(this.clientsPlayer.getAddress());
                this.clientsPlayer.setStatus(Player.Status.MAIN_MENU);
                this.debug("New player added to multiplayer: Queue contains " + this.hostServer.multiplayerQueue.getPlayers().size());
                break;
            }
            case "REMOVEPLAYER": {
                n = "Removing client from matchmaking...";
                Player player = this.hostServer.getMultiplayerQueue().getPlayerByAddress(this.clientsAddress);
                this.debug("Removing client from search queue: Current size: " + this.hostServer.getMultiplayerQueue().getPlayers().size());
                this.hostServer.getMultiplayerQueue().removePlayer(player);
                this.debug("Removing client from search queue: new size: " + this.hostServer.getMultiplayerQueue().getPlayers().size());
                break;
            }
            case "REMOVE_CLIENT": {
                n = "Removing client from ...";
                this.debug("Removing client from server ");
                this.hostServer.decrementClientCount(this.clientsAddress);
                break;
            }
            case "DC": {
                int k = 0;
                this.hostServer.decrementClientCount(this.clientsAddress);
                this.debug("Paired client size: " + this.hostServer.getPairedClients().size());
                for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                    SocketHandler s1 = entry.getKey();
                    SocketHandler s2 = entry.getValue();
                    if (s1.getPlayer().getAddress().equals(this.clientsAddress) || s2.getPlayer().getAddress().equals(this.clientsAddress)) {
                        this.hostServer.getMultiplayerGames().get(k).cancel(true);
                        this.hostServer.getPairedClients().remove(s1);
                        this.hostServer.getPairedClients().remove(s2);
                        break;
                    }
                    ++k;
                }
                this.debug("Paired client size updated: " + this.hostServer.getPairedClients().size());
                break;
            }
            case "STATUS_SETUP": {
                this.clientsPlayer.setStatus(Player.Status.SETUP);
                break;
            }
            case "STATUS_GAME": {
                this.clientsPlayer.setStatus(Player.Status.IN_GAME);
                break;
            }
            case "GAME_WON": {
                for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                    SocketHandler s1 = entry.getKey();
                    SocketHandler s2 = entry.getValue();
                    if (s1.getPlayer().getAddress().equals(this.clientsAddress)) {
                        s1.getPlayer().setStatus(Player.Status.GAME_OVER);
                        s2.sendPacketToClient("GAME_LOSS");
                        break block15;
                    }
                    if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                    s2.getPlayer().setStatus(Player.Status.GAME_OVER);
                    s1.sendPacketToClient("GAME_LOSS");
                    break block15;
                }
                break;
            }
            case "GAME_LOSS": {
                for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                    SocketHandler s1 = entry.getKey();
                    SocketHandler s2 = entry.getValue();
                    if (s1.getPlayer().getAddress().equals(this.clientsAddress)) {
                        s1.getPlayer().setStatus(Player.Status.GAME_OVER);
                        s2.sendPacketToClient("GAME_WON");
                        break block15;
                    }
                    if (!s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                    s2.getPlayer().setStatus(Player.Status.GAME_OVER);
                    s1.sendPacketToClient("GAME_WON");
                    break block15;
                }
                break;
            }
            case "SWITCHTURNS": {
                for (Map.Entry<SocketHandler, SocketHandler> entry : this.hostServer.getPairedClients().entrySet()) {
                    SocketHandler s1 = entry.getKey();
                    SocketHandler s2 = entry.getValue();
                    if (!s1.getPlayer().getAddress().equals(this.clientsAddress) && !s2.getPlayer().getAddress().equals(this.clientsAddress)) continue;
                    if (s1.getPlayer().isTurn()) {
                        s2.getPlayer().setTurn(true);
                        s1.getPlayer().setTurn(false);
                        break block15;
                    }
                    s2.getPlayer().setTurn(false);
                    s1.getPlayer().setTurn(true);
                    break block15;
                }
                break;
            }
            default: {
                n = "Unknown request on call (" + s + ")";
            }
        }
        return n;
    }
}

