/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import server.ServerWindow;
import server.SocketHandler;
import session.GameSession;
import session.MultiplayerQueue;
import session.Player;
import session.SessionLoop;

public class Server
implements Runnable {
    public int PORT;
    public int TIMEOUT;
    public boolean DEBUG = true;
    public ServerSocket mainServer;
    public ServerWindow mainFrame;
    public MultiplayerQueue multiplayerQueue = null;
    public SessionLoop sessionLoop = null;
    public ArrayList<ScheduledFuture<?>> multiplayerGames = new ArrayList();
    public HashMap<String, SocketHandler> connections = new HashMap();
    public HashMap<SocketHandler, SocketHandler> pairedClients = new HashMap();
    public static ExecutorService executor = Executors.newFixedThreadPool(100);
    public static ScheduledExecutorService loops;

    public Server(int port, int timeout) {
        try {
            this.PORT = port;
            this.TIMEOUT = timeout;
            this.mainServer = new ServerSocket(port);
            this.mainServer.setSoTimeout(timeout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFrame(ServerWindow f) {
        this.mainFrame = f;
    }

    public void debug(String s) {
        if (this.DEBUG) {
            System.out.println("[SERVER]: " + s);
            this.mainFrame.writeToConsole("[SERVER]: " + s);
        }
    }

    public HashMap<String, SocketHandler> getClients() {
        return this.connections;
    }

    public int getNumberOfConnections() {
        return this.connections.size();
    }

    public SocketHandler addClient(SocketHandler h) {
        this.connections.put(h.getAddress(), h);
        executor.submit(h);
        this.mainFrame.updateTable();
        return h;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.debug("Waiting on incoming connections on port: " + this.PORT + " at " + this.mainServer.getInetAddress());
                final Socket socket = this.mainServer.accept();
                this.debug("Connection established at " + socket.getRemoteSocketAddress() + ", sending to socket handler");
                Player pp = new Player();
                pp.setClientAddress(socket.getRemoteSocketAddress().toString());
                SocketHandler h = new SocketHandler(socket, this.getNumberOfConnections() + 1, this, pp, null);
                this.addClient(h);
                if (this.multiplayerQueue == null) {
                    this.multiplayerQueue = new MultiplayerQueue();
                }
                ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
                final ScheduledExecutorService loops = Executors.newScheduledThreadPool(25);
                exec.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        GameSession gs = Server.this.multiplayerQueue.checkForMatch();
                        if (gs != null) {
                            Server.this.debug("Game session: Player 1: " + gs.getPlayer1().getAddress() + " | Player 2: " + gs.getPlayer2().getAddress() + " | Index : " + gs.getGameIndex());
                            if (gs.getPlayer1().getAddress().equals(socket.getRemoteSocketAddress().toString())) {
                                Server.this.connections.get(gs.getPlayer1().getAddress()).setOpponent(gs.getPlayer2());
                                System.out.println("Set opponent for p1");
                            }
                            if (gs.getPlayer2().getAddress().equals(socket.getRemoteSocketAddress().toString())) {
                                Server.this.connections.get(gs.getPlayer1().getAddress()).setOpponent(gs.getPlayer1());
                                System.out.println("Set opponent for p2");
                            }
                            Server.this.pairedClients.put(Server.this.connections.get(gs.getPlayer1().getAddress()), Server.this.connections.get(gs.getPlayer2().getAddress()));
                            SessionLoop sl = new SessionLoop(Server.this.connections.get(gs.getPlayer1().getAddress()), Server.this.connections.get(gs.getPlayer2().getAddress()));
                            ScheduledFuture<?> fut = loops.scheduleAtFixedRate(sl, 0L, 1L, TimeUnit.SECONDS);
                            Server.this.multiplayerGames.add(fut);
                        }
                    }
                }, 0L, 2L, TimeUnit.SECONDS);
                this.debug("Game sessions size: " + this.pairedClients.size());
            }
        }
        catch (SocketTimeoutException s) {
            this.debug("Socket timed out after " + this.TIMEOUT / 1000 + " seconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MultiplayerQueue getMultiplayerQueue() {
        return this.multiplayerQueue;
    }

    public ArrayList<ScheduledFuture<?>> getMultiplayerGames() {
        return this.multiplayerGames;
    }

    public HashMap<SocketHandler, SocketHandler> getPairedClients() {
        return this.pairedClients;
    }

    public void decrementClientCount(String adress) {
        this.debug("Paired client size: " + this.getPairedClients().size());
        for (Map.Entry<SocketHandler, SocketHandler> entry : this.getPairedClients().entrySet()) {
            SocketHandler s1 = entry.getKey();
            SocketHandler s2 = entry.getValue();
            if (s1.getPlayer().getAddress().equals(adress)) {
                s1.getPlayer().setStatus(Player.Status.DISCONNECTED);
                break;
            }
            if (!s2.getPlayer().getAddress().equals(adress)) continue;
            s2.getPlayer().setStatus(Player.Status.DISCONNECTED);
            break;
        }
        this.debug("Paired client size updated: " + this.getPairedClients().size());
        this.connections.remove(adress);
        this.mainFrame.updateTable();
        this.debug("A client has disconnected, total connected clients: " + this.getNumberOfConnections());
    }
}

