/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import server.Server;
import server.SocketHandler;

public class ScrollableTable
extends JPanel {
    public HashMap<String, SocketHandler> clients;
    public JTable table;
    public Server mainServer;

    public ScrollableTable(HashMap<String, SocketHandler> hm, final Server ms) {
        this.clients = hm;
        this.mainServer = ms;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 200));
        TableModel m = this.toTableModel(hm);
        this.table = new JTable(m);
        JScrollPane pane = new JScrollPane(this.table);
        pane.setPreferredSize(new Dimension(800, 200));
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("Kick client");
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v = ScrollableTable.this.table.getSelectedRow();
                String value = (String)ScrollableTable.this.table.getValueAt(v, 1);
                ms.decrementClientCount(value);
                JOptionPane.showMessageDialog(ScrollableTable.this.table, "Client kicked off the server ");
            }
        });
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int rowAtPoint = ScrollableTable.this.table.rowAtPoint(SwingUtilities.convertPoint(popupMenu, new Point(0, 0), ScrollableTable.this.table));
                        if (rowAtPoint > -1) {
                            ScrollableTable.this.table.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                            int n = (Integer)ScrollableTable.this.table.getValueAt(rowAtPoint, 0);
                        }
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popupMenu.add(deleteItem);
        this.table.setComponentPopupMenu(popupMenu);
        this.add((Component)pane, "South");
    }

    public TableModel toTableModel(Map<?, ?> map) {
        DefaultTableModel model = new DefaultTableModel(new Object[]{"Client ID", "Address"}, 0);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            SocketHandler h = (SocketHandler)entry.getValue();
            model.addRow(new Object[]{entry.getKey(), h.getAddress()});
        }
        return model;
    }

    public void updateClients(HashMap<String, SocketHandler> hm) {
        this.clients = hm;
        TableModel m = this.toTableModel(this.clients);
        this.table.setModel(m);
        this.table.repaint();
        this.repaint();
    }
}

