/*
 * Decompiled with CFR 0.152.
 */
package game.player;

import client.Global;
import game.Board;
import game.Piece;
import game.player.GamePlayer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NetworkPlayer
extends GamePlayer {
    public List<Piece> pieces = null;
    public ArrayList<Piece.PieceType> capturedPieces = new ArrayList();
    public ArrayList<Piece.PieceType> lostPieces = new ArrayList();

    @Override
    public boolean hasAtLeastOneMovablePiece() {
        return true;
    }

    @Override
    public boolean hasPiece(Piece piece) {
        return this.pieces.stream().anyMatch(i -> i.equals(piece));
    }

    @Override
    public Optional<Piece> getPiece(int x, int y) {
        Optional<Piece> piece = this.pieces.stream().filter(i -> i.getColumn() == x && i.getRow() == y).findFirst();
        if (piece.isPresent()) {
            return piece;
        }
        return null;
    }

    @Override
    public Piece getPiece(Piece piece) {
        Optional<Piece> p = this.pieces.stream().filter(i -> i.equals(piece)).findFirst();
        return p.isPresent() ? p.get() : null;
    }

    @Override
    public Optional<Piece> getPiece(Point point) {
        return this.getPiece(point.x, point.y);
    }

    @Override
    public boolean removePiece(Piece piece) {
        System.out.println("Removing network Piece: " + piece.getPieceType().name());
        Board.addCapturedPiece(piece.getPieceType());
        this.lostPieces.add(piece.getPieceType());
        Optional<Piece> p = this.pieces.stream().filter(i -> i.getPosition().equals(piece.getPosition())).findAny();
        if (p.isPresent()) {
            Board.setPiece(piece.getColumn(), piece.getRow(), new Piece(Piece.PieceType.EMPTY));
            this.pieces.remove(p.get());
            System.out.println("removed network piece");
            return true;
        }
        System.out.println("Error finding piece in network player");
        return false;
    }

    @Override
    public boolean movePiece(Piece aPiece, Piece dPiece) {
        Board.setPiece(aPiece.getColumn(), aPiece.getRow(), new Piece(Piece.PieceType.EMPTY));
        this.removePiece(dPiece);
        Piece pp = aPiece.clone();
        pp.setPosition(dPiece.getColumn(), dPiece.getRow());
        Board.setPiece(pp.getColumn(), pp.getRow(), pp);
        this.pieces.add(pp);
        return true;
    }

    public boolean movePieceOrig(Piece dPiece, Piece aPiece) {
        Board.setPiece(dPiece.getColumn(), dPiece.getRow(), dPiece.setPieceType(Piece.PieceType.GENERIC));
        Board.setPiece(aPiece.getColumn(), aPiece.getRow(), new Piece(Piece.PieceType.EMPTY));
        Optional<Piece> p = this.myPieces.stream().filter(i -> i.getPosition().equals(aPiece.getPosition())).findAny();
        if (p.isPresent()) {
            ((Piece)this.myPieces.get(this.myPieces.indexOf(p.get()))).setPosition(dPiece.getColumn(), dPiece.getRow());
            return true;
        }
        System.out.println("Failed to move " + dPiece.getPieceType().name() + " to " + aPiece.getPosition().toString());
        return false;
    }

    public void setPieces(List<Piece> ps) {
        if (this.pieces != null) {
            this.pieces.clear();
        }
        this.pieces = ps;
    }

    public void addCapturedPiece(Piece piece) {
        Global.connectedServer.sendPacketToServer("SEND_CAPTURED" + (Object)((Object)piece.getPieceType()));
        this.capturedPieces.add(piece.getPieceType());
    }

    public List<Piece.PieceType> getCapturedPieces() {
        return this.capturedPieces;
    }

    public List<Piece.PieceType> getLostPieces() {
        return this.lostPieces;
    }

    @Override
    public List<Piece> getSanitizedPieces() {
        if (this.pieces == null) {
            System.out.println("Network pieces not ready yet");
            return null;
        }
        ArrayList<Piece> returnPieces = new ArrayList<Piece>();
        this.pieces.forEach(i -> returnPieces.add(new Piece(Piece.PieceType.GENERIC).setPosition(i.getPosition())));
        return returnPieces;
    }
}

