/*
 * Decompiled with CFR 0.152.
 */
package game.player;

import game.Piece;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class GamePlayer {
    protected List<Piece> myPieces = new ArrayList<Piece>();

    public List<Piece> getPieces() {
        return this.myPieces;
    }

    public boolean hasPiece(Piece piece) {
        return this.getPieces().stream().anyMatch(i -> i.equals(piece));
    }

    public abstract boolean hasAtLeastOneMovablePiece();

    public abstract boolean removePiece(Piece var1);

    public abstract boolean movePiece(Piece var1, Piece var2);

    public void movePiece(Piece piece, Point destination) {
        for (Piece p : this.myPieces) {
            if (!p.getPieceType().equals((Object)piece.getPieceType()) || !p.getPosition().equals(piece.getPosition())) continue;
            this.myPieces.set(this.myPieces.indexOf(p), p.clone().setPosition(destination));
            return;
        }
    }

    public List<Piece> getSanitizedPieces() {
        ArrayList<Piece> returnPieces = new ArrayList<Piece>();
        this.getPieces().forEach(i -> returnPieces.add(new Piece(Piece.PieceType.GENERIC).setPosition(i.getPosition())));
        return returnPieces;
    }

    public Optional<Piece> getPiece(int x, int y) {
        Optional<Piece> piece = this.getPieces().stream().filter(i -> i.getColumn() == x && i.getRow() == y).findFirst();
        if (piece.isPresent()) {
            return piece;
        }
        return null;
    }

    public Piece getPiece(Piece piece) {
        Optional<Piece> p = this.getPieces().stream().filter(i -> i.equals(piece)).findFirst();
        return p.isPresent() ? p.get() : null;
    }

    public Optional<Piece> getPiece(Point point) {
        return this.getPiece(point.x, point.y);
    }
}

