/*
 * Decompiled with CFR 0.152.
 */
package game.player;

import client.Global;
import game.Board;
import game.GameLogic;
import game.Piece;
import game.SetupContainer;
import game.player.GamePlayer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class AIPlayer
extends GamePlayer {
    private static List<pieceTracker> guessedPieces = new ArrayList<pieceTracker>();
    private static final int MAX_SCOUT = 7;
    private static final int MAX_BOMB_DEFUSER = 3;
    private static final int MAX_MINION = 6;
    private static final int MAX_BOMB = 2;
    private static final int MAX_MINOTAUR = 2;
    private static final int MAX_SKULL_KING = 1;
    private static final int MAX_SKULL_PRINCE = 1;
    private static final int MAX_NINJA_SPY = 1;
    private static final int MAX_FLAG = 1;
    public Piece currentPiece;
    public Piece ecurrentPiece;
    public static int turnnum;
    public static Point flaglocation;
    public static Point guessedFlag;
    private static HashMap<String, Integer> piececounter;

    public AIPlayer() {
        this(2);
    }

    public AIPlayer(int mode) {
        block25: {
            Object temp;
            Piece.PieceType[] game_Pieces;
            block26: {
                block24: {
                    int y;
                    int x;
                    this.myPieces = new ArrayList();
                    if (mode != 0) break block24;
                    List<Piece.PieceType> pieces = SetupContainer.getGamePieces();
                    Collections.shuffle(pieces);
                    int flatMap = pieces.size();
                    for (x = 0; x < 8; ++x) {
                        for (y = 0; y < 3; ++y) {
                            this.myPieces.add(new Piece(pieces.get(flatMap - 1)).setPosition(x, y));
                            --flatMap;
                        }
                    }
                    for (x = 0; x < 8; ++x) {
                        for (y = 5; y < 8; ++y) {
                            pieceTracker temp2 = new pieceTracker(new Piece(Piece.PieceType.GENERIC).setPosition(x, y), 0);
                            guessedPieces.add(temp2);
                        }
                    }
                    break block25;
                }
                if (mode != 1) break block26;
                this.myPieces.add(new Piece(Piece.PieceType.FLAG).setPosition(0, 3));
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(1, 3));
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(5, 3));
                this.myPieces.add(new Piece(Piece.PieceType.MINION).setPosition(0, 0));
                break block25;
            }
            if (mode != 2) break block25;
            turnnum = 0;
            ArrayList<Point> flag_spots = new ArrayList<Point>();
            flag_spots.add(new Point(0, 0));
            flag_spots.add(new Point(7, 0));
            Random rand = new Random();
            int flagnum = rand.nextInt(2);
            Point Bomb1 = null;
            Point Bomb2 = null;
            Point King = null;
            Point Spy = null;
            Point Princess = null;
            List<Piece.PieceType> rest = null;
            flaglocation = (Point)flag_spots.get(flagnum);
            this.myPieces.add(new Piece(Piece.PieceType.FLAG).setPosition((Point)flag_spots.get(flagnum)));
            if (((Point)flag_spots.get(flagnum)).equals(new Point(0, 0))) {
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(0, 1));
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(1, 0));
                Bomb1 = new Point(1, 0);
                Bomb2 = new Point(0, 1);
                game_Pieces = new Piece.PieceType[]{Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINOTAUR, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINOTAUR};
                rest = Arrays.asList(game_Pieces);
            } else if (((Point)flag_spots.get(flagnum)).equals(new Point(7, 0))) {
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(6, 0));
                this.myPieces.add(new Piece(Piece.PieceType.BOMB).setPosition(7, 1));
                Bomb1 = new Point(6, 0);
                Bomb2 = new Point(7, 1);
                game_Pieces = new Piece.PieceType[]{Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINOTAUR, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINOTAUR};
                rest = Arrays.asList(game_Pieces);
            }
            Random rand1 = new Random();
            int randkingloc = rand1.nextInt(1);
            int randkingloc2 = rand1.nextInt(2);
            int distking = rand1.nextInt(2);
            int distninja = rand1.nextInt(2);
            int kingrow = 0;
            int princerow = 0;
            if (randkingloc == 0) {
                if (Bomb2.getX() != 0.0) {
                    kingrow = 0 + randkingloc2;
                    princerow = kingrow + (3 + distking);
                } else {
                    kingrow = 1 + randkingloc2;
                    princerow = kingrow + (2 + distking);
                }
            } else if (Bomb2.getX() != 7.0) {
                kingrow = 7 - randkingloc2;
                princerow = kingrow - (3 + distking);
            } else {
                kingrow = 6 - randkingloc2;
                princerow = kingrow - (2 + distking);
            }
            switch (distninja) {
                case 0: {
                    if ((double)princerow != Bomb1.getX() && Bomb1.getY() == 0.0) {
                        this.myPieces.add(new Piece(Piece.PieceType.NINJA_SPY).setPosition(princerow, 0));
                        Spy = new Point(princerow, 0);
                        break;
                    }
                    if (princerow == 6) {
                        this.myPieces.add(new Piece(Piece.PieceType.NINJA_SPY).setPosition(princerow - 1, 1));
                        Spy = new Point(princerow - 1, 1);
                        break;
                    }
                    this.myPieces.add(new Piece(Piece.PieceType.NINJA_SPY).setPosition(princerow + 1, 1));
                    Spy = new Point(princerow + 1, 1);
                    break;
                }
                case 1: {
                    if (princerow > 3) {
                        this.myPieces.add(new Piece(Piece.PieceType.NINJA_SPY).setPosition(princerow - 1, 1));
                        Spy = new Point(princerow - 1, 1);
                        break;
                    }
                    this.myPieces.add(new Piece(Piece.PieceType.NINJA_SPY).setPosition(princerow + 1, 1));
                    Spy = new Point(princerow + 1, 1);
                    break;
                }
            }
            this.myPieces.add(new Piece(Piece.PieceType.SKULL_KING).setPosition(kingrow, 1));
            King = new Point(kingrow, 1);
            this.myPieces.add(new Piece(Piece.PieceType.SKULL_PRINCE).setPosition(princerow, 1));
            Princess = new Point(princerow, 1);
            int restsz = 0;
            Collections.shuffle(rest);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 8; ++x) {
                    temp = new Point(x, y);
                    if (((Point)temp).equals(Bomb1) || ((Point)temp).equals(Bomb2) || ((Point)temp).equals(flag_spots.get(flagnum)) || ((Point)temp).equals(King) || ((Point)temp).equals(Princess) || ((Point)temp).equals(Spy) || restsz == rest.size()) continue;
                    this.myPieces.add(new Piece(rest.get(restsz)).setPosition(x, y));
                    ++restsz;
                }
            }
            for (int x = 0; x < 8; ++x) {
                for (int y = 5; y < 8; ++y) {
                    temp = new pieceTracker(new Piece(Piece.PieceType.GENERIC).setPosition(x, y), 0);
                    guessedPieces.add((pieceTracker)temp);
                }
            }
        }
    }

    public void intilizemap() {
        piececounter.put(Piece.PieceType.FLAG.name(), 0);
        piececounter.put(Piece.PieceType.MINION.name(), 0);
        piececounter.put(Piece.PieceType.BOMB.name(), 0);
        piececounter.put(Piece.PieceType.MINOTAUR.name(), 0);
        piececounter.put(Piece.PieceType.SCOUT.name(), 0);
        piececounter.put(Piece.PieceType.SKULL_KING.name(), 0);
        piececounter.put(Piece.PieceType.SKULL_PRINCE.name(), 0);
        piececounter.put(Piece.PieceType.BOMB_DEFUSER.name(), 0);
        piececounter.put(Piece.PieceType.NINJA_SPY.name(), 0);
    }

    public List<List<Piece>> testmove(Piece start, Piece end, List<Piece> enemypieces, List<Piece> mypieces) {
        for (Piece piece : enemypieces) {
            if (!end.getPosition().equals(piece.getPosition())) continue;
            return this.testattack(start, piece, enemypieces, mypieces);
        }
        for (Piece piece : mypieces) {
            if (!start.getPosition().equals(piece.getPosition())) continue;
            piece.setPosition(end.getPosition());
            break;
        }
        ArrayList<List<Piece>> temp = new ArrayList<List<Piece>>();
        temp.add(mypieces);
        temp.add(enemypieces);
        return temp;
    }

    private List<List<Piece>> testattack(Piece aPiece, Piece dPiece, List<Piece> enemypieces, List<Piece> mypieces) {
        if (dPiece.getPieceType().isPieceSpecial()) {
            switch (dPiece.getPieceType()) {
                case BOMB: {
                    if (aPiece.getPieceType().equals((Object)Piece.PieceType.BOMB_DEFUSER)) {
                        for (Piece p : mypieces) {
                            if (!p.getPosition().equals(aPiece.getPosition())) continue;
                            p.setPosition(dPiece.getPosition());
                        }
                        enemypieces.remove(dPiece);
                        break;
                    }
                    mypieces.remove(aPiece);
                }
            }
        } else {
            if (aPiece.getPieceType().equals((Object)Piece.PieceType.NINJA_SPY) && dPiece.getPieceType().equals((Object)Piece.PieceType.SKULL_KING)) {
                for (Piece p : mypieces) {
                    if (!p.getPosition().equals(aPiece.getPosition())) continue;
                    p.setPosition(dPiece.getPosition());
                }
                enemypieces.remove(dPiece);
            }
            if (aPiece.getPieceType().getCombatValue() == dPiece.getPieceType().getCombatValue()) {
                mypieces.remove(aPiece);
                enemypieces.remove(dPiece);
            } else if (aPiece.getPieceType().getCombatValue() > dPiece.getPieceType().getCombatValue()) {
                mypieces.remove(aPiece);
            } else {
                for (Piece p : mypieces) {
                    if (!p.getPosition().equals(aPiece.getPosition())) continue;
                    p.setPosition(dPiece.getPosition());
                }
                enemypieces.remove(dPiece);
            }
        }
        ArrayList<List<Piece>> temp = new ArrayList<List<Piece>>();
        temp.add(mypieces);
        temp.add(enemypieces);
        return temp;
    }

    public static List<Piece> guessesBoard() {
        Collections.sort(guessedPieces, new Comparator<pieceTracker>(){

            @Override
            public int compare(pieceTracker o1, pieceTracker o2) {
                if (o1.known && o2.known) {
                    return 0;
                }
                if (o2.known) {
                    return 1;
                }
                if (o1.known) {
                    return -1;
                }
                if (o2.timesMoved == o1.timesMoved) {
                    return 0;
                }
                return o1.timesMoved > o2.timesMoved ? -1 : 1;
            }
        });
        ArrayList<Piece> guessedp = new ArrayList<Piece>();
        for (pieceTracker pt : guessedPieces) {
            if (!pt.piece.getPieceType().equals((Object)Piece.PieceType.GENERIC)) {
                guessedp.add(pt.piece);
                piececounter.put(pt.piece.getPieceType().name(), piececounter.get(pt.piece.getPieceType().name()) + 1);
                continue;
            }
            Piece temp = pt.piece.clone();
            if (2 - piececounter.get(Piece.PieceType.MINOTAUR.name()) > 0) {
                piececounter.put(Piece.PieceType.MINOTAUR.name(), piececounter.get(Piece.PieceType.MINOTAUR.name()) + 1);
                temp.setPieceType(Piece.PieceType.MINOTAUR);
                guessedp.add(temp);
                continue;
            }
            if (6 - piececounter.get(Piece.PieceType.MINION.name()) > 0) {
                piececounter.put(Piece.PieceType.MINION.name(), piececounter.get(Piece.PieceType.MINION.name()) + 1);
                temp.setPieceType(Piece.PieceType.MINION);
                guessedp.add(temp);
                continue;
            }
            if (7 - piececounter.get(Piece.PieceType.SCOUT.name()) > 0) {
                piececounter.put(Piece.PieceType.SCOUT.name(), piececounter.get(Piece.PieceType.SCOUT.name()) + 1);
                temp.setPieceType(Piece.PieceType.SCOUT);
                guessedp.add(temp);
                continue;
            }
            if (1 - piececounter.get(Piece.PieceType.SKULL_KING.name()) > 0) {
                piececounter.put(Piece.PieceType.SKULL_KING.name(), piececounter.get(Piece.PieceType.SKULL_KING.name()) + 1);
                temp.setPieceType(Piece.PieceType.SKULL_KING);
                guessedp.add(temp);
                continue;
            }
            if (1 - piececounter.get(Piece.PieceType.SKULL_PRINCE.name()) > 0) {
                piececounter.put(Piece.PieceType.SKULL_PRINCE.name(), piececounter.get(Piece.PieceType.SKULL_PRINCE.name()) + 1);
                temp.setPieceType(Piece.PieceType.SKULL_PRINCE);
                guessedp.add(temp);
                continue;
            }
            if (3 - piececounter.get(Piece.PieceType.BOMB_DEFUSER.name()) > 0) {
                piececounter.put(Piece.PieceType.BOMB_DEFUSER.name(), piececounter.get(Piece.PieceType.BOMB_DEFUSER.name()) + 1);
                temp.setPieceType(Piece.PieceType.BOMB_DEFUSER);
                guessedp.add(temp);
                continue;
            }
            if (1 - piececounter.get(Piece.PieceType.NINJA_SPY.name()) > 0) {
                piececounter.put(Piece.PieceType.NINJA_SPY.name(), piececounter.get(Piece.PieceType.NINJA_SPY.name()) + 1);
                temp.setPieceType(Piece.PieceType.NINJA_SPY);
                guessedp.add(temp);
                continue;
            }
            if (2 - piececounter.get(Piece.PieceType.BOMB.name()) > 0) {
                piececounter.put(Piece.PieceType.BOMB.name(), piececounter.get(Piece.PieceType.BOMB.name()) + 1);
                temp.setPieceType(Piece.PieceType.BOMB);
                guessedp.add(temp);
                continue;
            }
            if (1 - piececounter.get(Piece.PieceType.FLAG.name()) <= 0) continue;
            guessedFlag = new Point(temp.getPosition());
            piececounter.put(Piece.PieceType.FLAG.name(), piececounter.get(Piece.PieceType.FLAG.name()) + 1);
            temp.setPieceType(Piece.PieceType.FLAG);
            guessedp.add(temp);
        }
        return guessedp;
    }

    public int Scorer(List<Piece> aipieces, List<Piece> playerpieces, int depth) {
        pieceTracker p2;
        Iterator<pieceTracker> iterator;
        int score = 0;
        if (this.currentPiece.getPieceType().equals((Object)Piece.PieceType.SCOUT) && turnnum < 25) {
            ++score;
        }
        if (guessedFlag != null && this.currentPiece.getPosition().distance(guessedFlag) > this.ecurrentPiece.getPosition().distance(guessedFlag)) {
            score += 2;
            if (turnnum > 15) {
                score += 5;
            }
        }
        if (this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY) && (iterator = guessedPieces.iterator()).hasNext()) {
            p2 = iterator.next();
            if (p2.piece.getPieceType().getCombatValue() < this.currentPiece.getPieceType().getCombatValue() && p2.piece.getPosition().distance(this.currentPiece.getPosition()) == 1.0) {
                --score;
            }
            if (p2.known) {
                score -= 3;
            }
        }
        if (this.currentPiece.getPieceType().equals((Object)Piece.PieceType.BOMB_DEFUSER) && (iterator = guessedPieces.iterator()).hasNext()) {
            p2 = iterator.next();
            if (p2.piece.getPieceType().equals((Object)Piece.PieceType.BOMB) && p2.piece.getPosition().distance(this.currentPiece.getPosition()) > p2.piece.getPosition().distance(this.ecurrentPiece.getPosition())) {
                score = 10;
            }
        }
        if (turnnum > 25) {
            for (pieceTracker p2 : guessedPieces) {
                if (!(flaglocation.distance(p2.piece.getPosition()) < 6.0 & this.currentPiece.getPieceType().getCombatValue() < 5)) continue;
                score += 7;
                break;
            }
        }
        if (this.currentPiece.getPieceType().getCombatValue() < 4) {
            ++score;
        }
        if (this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            for (pieceTracker p2 : guessedPieces) {
                if (p2.piece.getPosition().distance(this.currentPiece.getPosition()) != 1.0 || p2.known || p2.piece.getPieceType().getCombatValue() <= this.currentPiece.getPieceType().getCombatValue()) continue;
                score += 2;
                break;
            }
        }
        if (this.currentPiece.getPieceType().getCombatValue() > 3 && this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || p2.known) continue;
                ++score;
                if (p2.timesMoved == 0) break;
                ++score;
                break;
            }
        }
        if (turnnum > 30 && this.currentPiece.getPieceType().equals((Object)Piece.PieceType.SCOUT)) {
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || p2.timesMoved != 0) continue;
                score += 2;
                break;
            }
        }
        if (!this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || p2.known || p2.timesMoved == 0) continue;
                if (this.currentPiece.getPieceType().getCombatValue() >= 5) break;
                score += 2;
                break;
            }
        }
        if (this.ecurrentPiece.getPieceType().getCombatValue() > this.currentPiece.getPieceType().getCombatValue() && !this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            score += 3;
            if (this.currentPiece.getPieceType().getCombatValue() < 4) {
                score += 2;
            }
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || !p2.known || p2.timesMoved == 0) continue;
                score += 50;
                break;
            }
        }
        if (this.ecurrentPiece.getPieceType().getCombatValue() < this.currentPiece.getPieceType().getCombatValue() && !this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            score -= 3;
        }
        if (this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.FLAG) && turnnum > 10) {
            score += 1000;
        }
        if (this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.BOMB) && this.currentPiece.getPieceType().equals((Object)Piece.PieceType.BOMB_DEFUSER)) {
            score += 4;
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || !p2.known) continue;
                score += 60;
            }
        }
        if (this.ecurrentPiece.getPieceType().equals((Object)Piece.PieceType.SKULL_KING) && this.currentPiece.getPieceType().equals((Object)Piece.PieceType.NINJA_SPY)) {
            score += 15;
            for (pieceTracker p2 : guessedPieces) {
                if (!p2.piece.getPosition().equals(this.ecurrentPiece.getPosition()) || !p2.known) continue;
                score += 70;
                break;
            }
        }
        return score;
    }

    public bestMove getBestmove(List<Piece> aipieces, List<Piece> playerpieces, int depth) {
        bestMove bm = null;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        Collections.shuffle(aipieces);
        for (Piece piece : aipieces) {
            ArrayList<Piece> temp = new ArrayList<Piece>();
            temp.addAll(AIPlayer.testgetMovableTiles(piece, aipieces, playerpieces));
            this.currentPiece = piece;
            if (temp.isEmpty()) continue;
            Iterator iterator = temp.iterator();
            while (iterator.hasNext()) {
                Piece p;
                this.ecurrentPiece = p = (Piece)iterator.next();
                List<Object> listtemp = new ArrayList();
                ArrayList<Piece> atemplist = new ArrayList<Piece>();
                for (Piece t : aipieces) {
                    atemplist.add(t.clone());
                }
                ArrayList<Piece> ptemplist = new ArrayList<Piece>();
                for (Piece t : playerpieces) {
                    ptemplist.add(t.clone());
                }
                listtemp = this.testmove(piece, p, ptemplist, atemplist);
                int current = this.min((List)listtemp.get(0), (List)listtemp.get(1), depth - 1);
                if (max >= current) continue;
                max = current;
                bm = new bestMove(piece, p);
            }
        }
        return bm;
    }

    public int max(List<Piece> aipieces, List<Piece> playerpieces, int depth) {
        if (depth == 0) {
            return this.Scorer(aipieces, playerpieces, depth);
        }
        int max = Integer.MIN_VALUE;
        for (Piece piece : aipieces) {
            List<Piece> temp = AIPlayer.testgetMovableTiles(piece, aipieces, playerpieces);
            if (temp.isEmpty()) continue;
            for (Piece p : temp) {
                List<Object> listtemp = new ArrayList();
                ArrayList<Piece> atemplist = new ArrayList<Piece>();
                for (Piece piece2 : aipieces) {
                    atemplist.add(piece2.clone());
                }
                ArrayList<Piece> ptemplist = new ArrayList<Piece>();
                for (Piece t3 : playerpieces) {
                    ptemplist.add(t3.clone());
                }
                listtemp = this.testmove(piece, p, ptemplist, atemplist);
                int n = this.min((List)listtemp.get(0), (List)listtemp.get(1), depth - 1);
                if (n < max) continue;
                max = n;
            }
        }
        return max;
    }

    public int min(List<Piece> aipieces, List<Piece> playerpieces, int depth) {
        if (depth == 0) {
            return this.Scorer(aipieces, playerpieces, depth);
        }
        int min = Integer.MAX_VALUE;
        for (Piece piece : aipieces) {
            List<Piece> temp = AIPlayer.testgetMovableTiles(piece, playerpieces, aipieces);
            if (temp.isEmpty()) continue;
            for (Piece p : temp) {
                List<Object> listtemp = new ArrayList();
                ArrayList<Piece> atemplist = new ArrayList<Piece>();
                for (Piece piece2 : aipieces) {
                    atemplist.add(piece2.clone());
                }
                ArrayList<Piece> ptemplist = new ArrayList<Piece>();
                for (Piece t3 : playerpieces) {
                    ptemplist.add(t3.clone());
                }
                listtemp = this.testmove(piece, p, atemplist, ptemplist);
                int n = this.max((List)listtemp.get(1), (List)listtemp.get(0), depth - 1);
                if (n >= min) continue;
                min = n;
            }
        }
        return min;
    }

    public static void updatetracker(Piece p, Piece pd, moveUpdate move) {
        if (move.equals((Object)moveUpdate.ATTACKWIN)) {
            for (pieceTracker pt : guessedPieces) {
                if (!pt.piece.getPosition().equals(p.getPosition())) continue;
                pt.piece.setPieceType(p.getPieceType()).setPosition(pd.getPosition());
                pt.known = true;
                int cdist = Math.abs(p.getColumn() - pd.getColumn());
                int rdist = Math.abs(p.getRow() - pd.getRow());
                pt.timesMoved = cdist > rdist ? cdist : rdist;
                break;
            }
        } else if (move.equals((Object)moveUpdate.ATTACKLOSS) || move.equals((Object)moveUpdate.TIE)) {
            for (pieceTracker pt : guessedPieces) {
                if (!pt.piece.getPosition().equals(p.getPosition())) continue;
                guessedPieces.remove(pt);
                break;
            }
        } else if (move.equals((Object)moveUpdate.MOVE)) {
            for (pieceTracker pt : guessedPieces) {
                if (!pt.piece.getPosition().equals(p.getPosition())) continue;
                pt.piece.setPosition(pd.getPosition());
                int cdist = Math.abs(p.getColumn() - pd.getColumn());
                int rdist = Math.abs(p.getRow() - pd.getRow());
                if (cdist > rdist) {
                    pt.timesMoved += cdist;
                    if (cdist <= 1) break;
                    pt.piece.setPieceType(Piece.PieceType.SCOUT);
                    pt.known = true;
                    break;
                }
                pt.timesMoved += rdist;
                if (rdist <= 1) break;
                pt.piece.setPieceType(Piece.PieceType.SCOUT);
                pt.known = true;
                break;
            }
        }
        if (Global.getBoardState().equals((Object)Global.BoardState.THEIR_TURN) && !Board.getEnemyPlayer().hasAtLeastOneMovablePiece()) {
            Global.setBoardState(Global.BoardState.GAME_WON);
        }
    }

    @Override
    public boolean hasAtLeastOneMovablePiece() {
        return this.getPieces().stream().anyMatch(p -> !GameLogic.getMovableTiles(p).isEmpty());
    }

    @Override
    public boolean removePiece(Piece piece) {
        Board.addCapturedPiece(piece.getPieceType());
        Optional<Piece> p = this.myPieces.stream().filter(i -> i.getPosition().equals(piece.getPosition())).findAny();
        if (p.isPresent()) {
            Board.setPiece(piece.getColumn(), piece.getRow(), new Piece(Piece.PieceType.EMPTY));
            this.myPieces.remove(p.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean movePiece(Piece aPiece, Piece dPiece) {
        Board.setPiece(dPiece.getColumn(), dPiece.getRow(), dPiece.setPieceType(Piece.PieceType.GENERIC));
        Board.setPiece(aPiece.getColumn(), aPiece.getRow(), new Piece(Piece.PieceType.EMPTY));
        Optional<Piece> p = this.myPieces.stream().filter(i -> i.getPosition().equals(aPiece.getPosition())).findAny();
        if (p.isPresent()) {
            ((Piece)this.myPieces.get(this.myPieces.indexOf(p.get()))).setPosition(dPiece.getColumn(), dPiece.getRow());
            return true;
        }
        return false;
    }

    public boolean nextMove() {
        ++turnnum;
        this.intilizemap();
        List<Piece> tempenemy = AIPlayer.guessesBoard();
        ArrayList<Piece> tempai = new ArrayList<Piece>();
        for (Piece p : this.myPieces) {
            tempai.add(p.clone());
        }
        bestMove bmade = this.getBestmove(tempai, tempenemy, 2);
        if (Board.getEnemyPlayer().hasAtLeastOneMovablePiece()) {
            Board.TurnState state = Board.move(bmade.beststart, bmade.bestend);
            if (Board.getPiece(bmade.bestend.getColumn(), bmade.bestend.getRow()).getPieceType().equals((Object)Piece.PieceType.FLAG)) {
                Global.setBoardState(Global.BoardState.GAME_LOSS);
                return true;
            }
            if (state.equals((Object)Board.TurnState.VALID)) {
                Global.setBoardState(Global.BoardState.MY_TURN);
                return true;
            }
        } else {
            Global.setBoardState(Global.BoardState.GAME_WON);
        }
        return false;
    }

    public static List<Piece> testgetMovableTiles(Piece piece, List<Piece> mypieces, List<Piece> epieces) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        if (piece != null) {
            if (piece.getPieceType().getCombatValue() == -1) {
                return pieces;
            }
            int mx = piece.getColumn();
            int my = piece.getRow();
            block0: for (Board.Direction dir : Board.Direction.values()) {
                for (int i = 0; i < piece.getMaxDistance(); ++i) {
                    int dy;
                    int dx = dir.equals((Object)Board.Direction.LEFT) || dir.equals((Object)Board.Direction.RIGHT) ? mx + dir.getOffset() * (i + 1) : mx;
                    int n = dy = dir.equals((Object)Board.Direction.UP) || dir.equals((Object)Board.Direction.DOWN) ? my + dir.getOffset() * (i + 1) : my;
                    if (dx < 0 || dy < 0 || dx >= 8 || dy >= 8) continue;
                    Piece p = new Piece(Piece.PieceType.EMPTY).setPosition(dx, dy);
                    Piece temp1 = new Piece(Piece.PieceType.BLOCK).setPosition(3, 3);
                    Piece temp2 = new Piece(Piece.PieceType.BLOCK).setPosition(4, 3);
                    Piece temp3 = new Piece(Piece.PieceType.BLOCK).setPosition(3, 4);
                    Piece temp4 = new Piece(Piece.PieceType.BLOCK).setPosition(3, 4);
                    for (Piece ptemp : mypieces) {
                        if (!ptemp.getPosition().equals(p.getPosition())) continue;
                        p = ptemp;
                    }
                    boolean has = false;
                    for (Piece ptemp : epieces) {
                        if (!ptemp.getPosition().equals(p.getPosition())) continue;
                        has = true;
                        p = ptemp;
                    }
                    if (p.getPosition().equals(temp1.getPosition()) || p.getPosition().equals(temp2.getPosition()) || p.getPosition().equals(temp3.getPosition()) || p.getPosition().equals(temp4.getPosition())) {
                        p.setPieceType(Piece.PieceType.BLOCK);
                    }
                    if (p.getPieceType().equals((Object)Piece.PieceType.EMPTY) || has) {
                        pieces.add(p);
                    }
                    if (!p.getPieceType().equals((Object)Piece.PieceType.EMPTY)) continue block0;
                }
            }
        }
        return pieces;
    }

    static {
        piececounter = new HashMap();
    }

    public static enum Turn {
        AI,
        LOCAL;

    }

    public static enum moveUpdate {
        MOVE,
        ATTACKLOSS,
        ATTACKWIN,
        TIE;

    }

    class bestMove {
        public Piece beststart;
        public Piece bestend;

        public bestMove(Piece p, Piece e) {
            this.beststart = p;
            this.bestend = e;
        }
    }

    class pieceTracker {
        public Piece piece;
        public int timesMoved;
        public boolean known;

        public pieceTracker(Piece p, int i) {
            this.piece = p;
            this.timesMoved = i;
            this.known = false;
        }
    }
}

