/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Piece;
import game.player.GamePlayer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SetupContainer
extends Rectangle {
    private int trueWidth;
    private int trueHeight;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private List<SetupTile> setupTiles = new ArrayList<SetupTile>();
    public static final Piece.PieceType[] GAME_PIECES = new Piece.PieceType[]{Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.SCOUT, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.BOMB_DEFUSER, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINION, Piece.PieceType.MINOTAUR, Piece.PieceType.MINOTAUR, Piece.PieceType.SKULL_PRINCE, Piece.PieceType.SKULL_KING, Piece.PieceType.BOMB, Piece.PieceType.BOMB, Piece.PieceType.NINJA_SPY, Piece.PieceType.FLAG};

    public static List<Piece.PieceType> getGamePieces() {
        return Arrays.asList(GAME_PIECES);
    }

    public static ArrayList<Piece.PieceType> getRemainingGamePieces(GamePlayer player) {
        ArrayList<Piece.PieceType> all = new ArrayList<Piece.PieceType>(SetupContainer.getGamePieces());
        for (Piece piece : player.getPieces()) {
            all.remove((Object)piece.getPieceType());
        }
        return all;
    }

    public SetupContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.trueWidth = this.width;
        this.trueHeight = this.height;
        this.tileWidth = this.trueWidth / 12;
        this.tileHeight = this.trueHeight / 2;
        this.tileXOffset = (this.tileWidth - 64) / 2;
        this.tileYOffset = (this.tileHeight - 64) / 2;
        this.initialize();
    }

    public void clear() {
        this.setupTiles.clear();
    }

    public void initialize() {
        this.clear();
        for (int i = 0; i < 24; ++i) {
            int ax = (i < 12 ? i * this.tileWidth : (i - 12) * this.tileWidth) + this.x;
            int ay = (i < 12 ? 0 : this.tileHeight) + this.y;
            this.setupTiles.add(new SetupTile(ax, ay, this.tileWidth, this.tileHeight).setType(GAME_PIECES[i]));
        }
    }

    public void removeTile(SetupTile tile) {
        this.setupTiles.remove(tile);
    }

    public List<SetupTile> getSetupTiles() {
        return this.setupTiles;
    }

    public int getTileXOffset() {
        return this.tileXOffset;
    }

    public int getTileYOffset() {
        return this.tileYOffset;
    }

    public class SetupTile
    extends Rectangle {
        private Piece.PieceType type;

        public SetupTile(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public SetupTile setType(Piece.PieceType pieceType) {
            this.type = pieceType;
            return this;
        }

        public Piece.PieceType getType() {
            return this.type;
        }
    }
}

