/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Board;
import game.Piece;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SaveLoad {
    public static String getPiecesAsString() {
        String playerSetup = "";
        for (int x = 0; x < Board.getLocalPlayer().getPieces().size(); ++x) {
            Piece p = Board.getLocalPlayer().getPieces().get(x);
            if (p.getPieceType().equals((Object)Piece.PieceType.EMPTY)) continue;
            playerSetup = playerSetup + p.getPieceType().name() + ":" + p.getColumn() + ":" + p.getRow() + ",";
        }
        return playerSetup;
    }

    public static String getPiecesAsString(List pieces) {
        String playerSetup = "";
        for (int x = 0; x < pieces.size(); ++x) {
            Piece p = (Piece)pieces.get(x);
            if (p.getPieceType().equals((Object)Piece.PieceType.EMPTY)) continue;
            playerSetup = playerSetup + p.getPieceType().name() + ":" + p.getColumn() + ":" + p.getRow() + ",";
        }
        return playerSetup;
    }

    public static String getPieceAsString(Piece p) {
        return p.getPieceType().name() + ":" + p.getColumn() + ":" + p.getRow();
    }

    public static void saveSetup() {
        String playerSetup = SaveLoad.getPiecesAsString();
        playerSetup = playerSetup + " ";
        try {
            BufferedWriter text = new BufferedWriter(new FileWriter(new File("PlayerSetup")));
            text.write(playerSetup);
            text.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Piece convertPiece(String pieceString) {
        String[] props = pieceString.split(":");
        int col = Integer.parseInt(props[1]);
        int row = Integer.parseInt(props[2]);
        String pieceName = props[0];
        Piece.PieceType pieceType = null;
        for (Piece.PieceType type : Piece.PieceType.values()) {
            if (!pieceName.equals(type.name())) continue;
            pieceType = type;
            break;
        }
        Piece boardPiece = new Piece(pieceType).setPosition(col, row);
        return boardPiece;
    }

    public static List<Piece> convertPieces(String piecesString) {
        String[] pieces;
        ArrayList<Piece> pieceList = new ArrayList<Piece>();
        for (String piece : pieces = piecesString.split(",")) {
            if (piece.length() < 2) break;
            String[] props = piece.split(":");
            int col = Integer.parseInt(props[1]);
            int row = Integer.parseInt(props[2]);
            String pieceName = props[0];
            Piece.PieceType pieceType = null;
            for (Piece.PieceType type : Piece.PieceType.values()) {
                if (!pieceName.equals(type.name())) continue;
                pieceType = type;
                break;
            }
            Piece boardPiece = new Piece(pieceType).setPosition(col, row);
            pieceList.add(boardPiece);
        }
        return pieceList;
    }

    public static List<Piece> convertPiecesWithFlip(String piecesString) {
        String[] pieces;
        ArrayList<Piece> pieceList = new ArrayList<Piece>();
        for (String piece : pieces = piecesString.split(",")) {
            int row;
            if (piece.length() < 2) break;
            String[] props = piece.split(":");
            int col = Integer.parseInt(props[1]);
            int k = row = Integer.parseInt(props[2]);
            row = 7 - k;
            String pieceName = props[0];
            Piece.PieceType pieceType = null;
            for (Piece.PieceType type : Piece.PieceType.values()) {
                if (!pieceName.equals(type.name())) continue;
                pieceType = type;
                break;
            }
            Piece boardPiece = new Piece(pieceType).setPosition(col, row);
            pieceList.add(boardPiece);
        }
        return pieceList;
    }

    public static boolean stateFileExists() {
        return new File("PlayerSetup").exists();
    }

    public static void loadSetup() {
        BufferedReader textReader = null;
        try {
            textReader = new BufferedReader(new FileReader(new File("PlayerSetup")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            for (Piece piece : SaveLoad.convertPieces(textReader.readLine())) {
                Board.setPiece(piece.getColumn(), piece.getRow(), piece);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

