/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Point;
import java.awt.Rectangle;

public class Piece {
    private PieceType pieceType = PieceType.EMPTY;
    private int col;
    private int row;

    public boolean equals(Object obj) {
        if (obj instanceof Piece) {
            return ((Piece)obj).col == this.col && ((Piece)obj).row == this.row;
        }
        return false;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.col * 64, this.row * 64, 64, 64);
    }

    public Piece setPosition(int col, int row) {
        this.col = col;
        this.row = row;
        return this;
    }

    public Piece setPosition(Point point) {
        this.col = point.x;
        this.row = point.y;
        return this;
    }

    public Piece clone() {
        return new Piece(this.pieceType).setPosition(this.getPosition());
    }

    public Piece clone(PieceType piece) {
        return new Piece(piece).setPosition(this.getPosition());
    }

    public Piece(PieceType pieceType) {
        this.pieceType = pieceType;
    }

    public PieceType getPieceType() {
        return this.pieceType;
    }

    public int getColumn() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public Point getPosition() {
        return new Point(this.col, this.row);
    }

    public int getMaxDistance() {
        return this.pieceType.equals((Object)PieceType.SCOUT) ? 10 : 1;
    }

    public Piece setPieceType(PieceType type) {
        this.pieceType = type;
        return this;
    }

    public static enum PieceType {
        SKULL_KING(1, 1, true, false, "Can be defeated by the Ninja Spy if attacked first"),
        SKULL_PRINCE(2, 2, true, false, null),
        MINOTAUR(3, 3, true, false, null),
        MINION(4, 4, true, false, null),
        BOMB_DEFUSER(5, 5, true, false, "The only unit that can destroy bombs"),
        SCOUT(6, 6, true, false, "Moves multiple tiles in any direction"),
        NINJA_SPY(7, 7, true, false, "Kills the Skull King if attacks first"),
        EMPTY(-1, -1, false, false, null),
        GENERIC(-1, -1, false, false, null),
        BLOCK(-1, 12, false, false, null),
        BOMB(-1, 10, false, true, null),
        FLAG(-1, 11, false, true, null);

        int combatValue;
        int spriteIndex;
        boolean selectable;
        boolean special;
        String info;

        private PieceType(int combatValue, int spriteIndex, boolean selectable, boolean special, String info) {
            this.combatValue = combatValue;
            this.spriteIndex = spriteIndex;
            this.selectable = selectable;
            this.special = special;
            this.info = info;
        }

        public boolean isPieceSpecial() {
            return this.special;
        }

        public int getCombatValue() {
            return this.combatValue;
        }

        public int getSpriteIndex() {
            return this.spriteIndex;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public boolean hasInfo() {
            return this.info != null;
        }

        public String getInfo() {
            return this.info;
        }
    }
}

