/*
 * Decompiled with CFR 0.152.
 */
package game;

import client.Global;
import game.Animation;
import game.Board;
import game.Piece;
import game.SaveLoad;
import game.player.AIPlayer;
import java.util.ArrayList;
import java.util.List;

public class GameLogic {
    public static boolean attack(Piece aPiece, Piece zPiece) {
        block43: {
            Piece dPiece;
            block42: {
                dPiece = Board.getCurrentOpposingPlayer().getPiece(zPiece);
                if (Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                    Animation.playAnimation(dPiece.getColumn(), dPiece.getRow(), dPiece.getPieceType().getSpriteIndex());
                } else {
                    Animation.playAnimation(aPiece.getColumn(), aPiece.getRow(), aPiece.getPieceType().getSpriteIndex());
                }
                Board.setLastMoveOnBoard(aPiece.getPosition(), GameLogic.getDirectionMove(aPiece, dPiece));
                if (!dPiece.getPieceType().isPieceSpecial()) break block42;
                switch (dPiece.getPieceType()) {
                    case BOMB: {
                        if (aPiece.getPieceType().equals((Object)Piece.PieceType.BOMB_DEFUSER)) {
                            if (Global.isNetworkGame()) {
                                Board.getEnemyPlayer().movePiece(aPiece, dPiece);
                                Global.getClient().sendPacketToServer("REMOVE_PIECE." + dPiece.getColumn() + "." + dPiece.getRow());
                            } else {
                                Board.setPiece(dPiece.getColumn(), dPiece.getRow(), aPiece.clone());
                                Board.setPiece(aPiece.getColumn(), aPiece.getRow(), new Piece(Piece.PieceType.EMPTY));
                                Board.addCapturedPiece(dPiece.getPieceType());
                            }
                            if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                                AIPlayer.updatetracker(aPiece, dPiece, AIPlayer.moveUpdate.ATTACKWIN);
                                break;
                            }
                            if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                                AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.ATTACKLOSS);
                                break;
                            }
                        } else {
                            Board.setPiece(aPiece.getColumn(), aPiece.getRow(), new Piece(Piece.PieceType.EMPTY));
                            Board.getCurrentPlayer().removePiece(aPiece);
                            if (Global.isNetworkGame()) {
                                Global.getClient().sendPacketToServer("UPDATE_LOCAL." + SaveLoad.getPiecesAsString(Board.getLocalPlayer().getPieces()));
                            }
                            if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                                AIPlayer.updatetracker(aPiece, aPiece, AIPlayer.moveUpdate.ATTACKLOSS);
                                break;
                            }
                            if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                                AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.ATTACKWIN);
                                break;
                            }
                        }
                        break block43;
                    }
                    case FLAG: {
                        return true;
                    }
                    default: {
                        System.out.println("Error: Reached end of game logic for special piece");
                        System.out.println("Piece 1: " + aPiece.getPieceType().name());
                        System.out.println("Piece 2: " + dPiece.getPieceType().name());
                        break;
                    }
                }
                break block43;
            }
            if (aPiece.getPieceType().equals((Object)Piece.PieceType.NINJA_SPY) && dPiece.getPieceType().equals((Object)Piece.PieceType.SKULL_KING)) {
                System.out.println("Spy has destroyed the almighty Skull King!");
                if (Global.isNetworkGame()) {
                    Board.getEnemyPlayer().movePiece(aPiece, dPiece);
                    Global.getClient().sendPacketToServer("REMOVE_PIECE." + dPiece.getColumn() + "." + dPiece.getRow());
                } else {
                    Board.getCurrentOpposingPlayer().removePiece(dPiece);
                    if (Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                        Board.getCurrentPlayer().movePiece(aPiece, dPiece);
                    } else {
                        Board.getCurrentPlayer().movePiece(dPiece, aPiece);
                    }
                }
                if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(aPiece, dPiece, AIPlayer.moveUpdate.ATTACKWIN);
                } else if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.ATTACKLOSS);
                }
            } else if (aPiece.getPieceType().getCombatValue() == dPiece.getPieceType().getCombatValue()) {
                Global.getClient().sendPacketToServer("REMOVE_PIECE." + dPiece.getColumn() + "." + dPiece.getRow());
                Global.getClient().sendPacketToServer("UPDATE_LOCAL." + SaveLoad.getPiecesAsString(Board.getLocalPlayer().getPieces()));
                Board.getCurrentPlayer().removePiece(aPiece);
                Board.getCurrentOpposingPlayer().removePiece(dPiece);
                System.out.println("Attacked an opponent with the same number");
                if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(aPiece, aPiece, AIPlayer.moveUpdate.TIE);
                } else if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.TIE);
                }
            } else if (aPiece.getPieceType().getCombatValue() > dPiece.getPieceType().getCombatValue()) {
                System.out.println("Attacked an opponent with a lower number");
                Board.getCurrentPlayer().removePiece(aPiece);
                if (Global.isNetworkGame()) {
                    Global.getClient().sendPacketToServer("UPDATE_LOCAL." + SaveLoad.getPiecesAsString(Board.getLocalPlayer().getPieces()));
                }
                if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(aPiece, aPiece, AIPlayer.moveUpdate.ATTACKLOSS);
                } else if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.ATTACKWIN);
                }
            } else {
                System.out.println("Attacked an opponent with a higher number");
                if (Global.isNetworkGame()) {
                    Board.getEnemyPlayer().movePiece(aPiece, dPiece);
                    Global.getClient().sendPacketToServer("REMOVE_PIECE." + dPiece.getColumn() + "." + dPiece.getRow());
                } else {
                    Board.getCurrentOpposingPlayer().removePiece(dPiece);
                    if (Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                        Board.getCurrentPlayer().movePiece(aPiece, dPiece);
                    } else {
                        Board.getCurrentPlayer().movePiece(dPiece, aPiece);
                    }
                }
                if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(aPiece, dPiece, AIPlayer.moveUpdate.ATTACKWIN);
                } else if (!Global.isNetworkGame() && Board.getCurrentPlayer().equals(Board.getEnemyPlayer())) {
                    AIPlayer.updatetracker(dPiece, dPiece, AIPlayer.moveUpdate.ATTACKLOSS);
                }
            }
        }
        return false;
    }

    public static List<Piece> getMovableTiles(Piece piece) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        if (piece != null) {
            if (piece.getPieceType().getCombatValue() == -1) {
                return pieces;
            }
            int mx = piece.getColumn();
            int my = piece.getRow();
            block0: for (Board.Direction dir : Board.Direction.values()) {
                for (int i = 0; i < piece.getMaxDistance(); ++i) {
                    int dy;
                    int dx = dir.equals((Object)Board.Direction.LEFT) || dir.equals((Object)Board.Direction.RIGHT) ? mx + dir.getOffset() * (i + 1) : mx;
                    int n = dy = dir.equals((Object)Board.Direction.UP) || dir.equals((Object)Board.Direction.DOWN) ? my + dir.getOffset() * (i + 1) : my;
                    if (dx < 0 || dy < 0 || dx >= 8 || dy >= 8) continue;
                    Piece p = Board.getPiece(dx, dy);
                    if (p.getPieceType().equals((Object)Piece.PieceType.EMPTY) || Board.getCurrentOpposingPlayer().hasPiece(p)) {
                        pieces.add(p);
                    }
                    if (!p.getPieceType().equals((Object)Piece.PieceType.EMPTY)) continue block0;
                }
            }
        }
        return pieces;
    }

    public static Board.Direction getDirectionMove(Piece src, Piece dst) {
        if (src.getPosition().getY() > dst.getPosition().getY()) {
            return Board.Direction.UP;
        }
        if (src.getPosition().getY() < dst.getPosition().getY()) {
            return Board.Direction.DOWN;
        }
        if (src.getPosition().getX() > dst.getPosition().getX()) {
            return Board.Direction.LEFT;
        }
        return Board.Direction.RIGHT;
    }
}

