/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.FontMetrics;
import java.awt.Rectangle;

public class BoardButton
extends Rectangle {
    private String buttonText;
    private int stringX;
    private int stringY;
    private boolean highlighted = false;
    private boolean enabled = true;

    BoardButton(int x, int y, int width, int height, String text) {
        super(x, y, width, height);
        this.buttonText = text;
    }

    public BoardButton setFontMetrics(FontMetrics metrics) {
        this.stringX = this.x + (this.width - metrics.stringWidth(this.buttonText)) / 2;
        this.stringY = this.y + (this.height - metrics.getHeight()) / 2 + metrics.getAscent();
        return this;
    }

    public int getStringX() {
        return this.stringX;
    }

    public int getStringY() {
        return this.stringY;
    }

    public String getString() {
        return this.buttonText;
    }

    public void setHighlighted(boolean value) {
        this.highlighted = value;
    }

    public BoardButton setEnabled(boolean value) {
        this.enabled = value;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }
}

