/*
 * Decompiled with CFR 0.152.
 */
package game;

import client.Global;
import client.resources.Images;
import client.screens.Screen;
import game.Animation;
import game.BoardButton;
import game.ConditionalSleep;
import game.GameLogic;
import game.Piece;
import game.SaveLoad;
import game.SetupContainer;
import game.player.AIPlayer;
import game.player.GamePlayer;
import game.player.LocalPlayer;
import game.player.NetworkPlayer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;

public class Board
implements Screen {
    public static final int SIZE_X = 8;
    public static final int SIZE_Y = 8;
    public static final int TILE_SIZE = 64;
    private static Piece selectedPiece = null;
    private static SetupContainer.SetupTile selectedTile = null;
    private static BoardButton selectedButton = null;
    private Font titleFont = new Font("Sans-Serif", 1, 16);
    private Color blackTransparent = new Color(0, 0, 0, 128);
    private Color whiteTransparent = new Color(192, 192, 192, 128);
    private Color greenTransparent = new Color(0, 155, 0, 128);
    private Color redTransparent = new Color(155, 0, 0, 128);
    private Color redTransparent2 = new Color(155, 0, 0, 190);
    private Color yellowTransparent = new Color(155, 155, 0, 128);
    private Color yellowTransparent2 = new Color(155, 155, 0, 64);
    private static BoardButton autoFillButton = new BoardButton(Global.WIDTH / 2 + 32, 8, Global.WIDTH / 2 - 64, 48, "Auto-Fill");
    private static BoardButton clearButton = new BoardButton(Global.WIDTH / 2 + 32, 104, Global.WIDTH / 2 - 64, 48, "Clear Board");
    private static BoardButton loadButton = new BoardButton(Global.WIDTH / 2 + 32, 200, Global.WIDTH / 2 - 64, 48, "Load Setup");
    private static BoardButton saveButton = new BoardButton(Global.WIDTH / 2 + 32, 296, Global.WIDTH / 2 - 64, 48, "Save Setup");
    private static BoardButton readyButton = new BoardButton(Global.WIDTH / 2 + 32, 392, Global.WIDTH / 2 - 64, 48, "Ready");
    private static BoardButton exitMainButton2 = new BoardButton(Global.WIDTH / 2 + 32, 488, Global.WIDTH / 2 - 64, 48, "Exit to Main Menu");
    private BoardButton exitMainButton = new BoardButton(64, 640, Global.WIDTH / 2 - 128, 48, "Exit to Main Menu");
    private static BoardButton mainMenuButton = new BoardButton(Global.WIDTH / 4 + 32, Global.HEIGHT / 2, Global.WIDTH / 2 - 64, 64, "Main Menu");
    private static Point getLastMoveOnBoard = null;
    private static Direction getLastDirectionOnBoard = null;
    private List<BoardButton> setupButtons = Arrays.asList(autoFillButton, clearButton, readyButton.setEnabled(false), loadButton.setEnabled(SaveLoad.stateFileExists()), saveButton.setEnabled(false), exitMainButton2);
    public static Map<Piece.PieceType, Integer> capturedPieces = new HashMap<Piece.PieceType, Integer>();
    public static Map<Piece.PieceType, Integer> lostPieces = new HashMap<Piece.PieceType, Integer>();
    private static GamePlayer enemyPlayer;
    private static LocalPlayer localPlayer;
    private static SetupContainer setupContainer;
    static Piece[][] pieces;

    public static void setLastMoveOnBoard(Point point, Direction dir) {
        Point p = point;
        point.setLocation(point.x * 64, point.y * 64);
        getLastMoveOnBoard = p;
        getLastDirectionOnBoard = dir;
    }

    public static GamePlayer getEnemyPlayer() {
        return enemyPlayer;
    }

    public static GamePlayer getLocalPlayer() {
        return localPlayer;
    }

    public static GamePlayer getCurrentPlayer() {
        return Global.getBoardState().equals((Object)Global.BoardState.MY_TURN) ? localPlayer : enemyPlayer;
    }

    public static GamePlayer getCurrentOpposingPlayer() {
        return Global.getBoardState().equals((Object)Global.BoardState.MY_TURN) ? enemyPlayer : localPlayer;
    }

    public static void setPieces(Piece[][] newPieces) {
        pieces = newPieces;
    }

    public static Piece[][] getPieces() {
        return pieces;
    }

    public static void addPieces(List<Piece> p) {
        p.forEach(i -> {
            Board.pieces[i.getColumn()][i.getRow()] = i;
        });
    }

    public static Piece getPiece2(int col, int row) {
        ArrayList<Piece> a = new ArrayList<Piece>(localPlayer.getPieces());
        a.addAll(enemyPlayer.getPieces());
        return a.stream().filter(i -> i.getPosition().equals(new Point(col, row))).findFirst().get();
    }

    public static void initialize() {
        getLastMoveOnBoard = null;
        getLastDirectionOnBoard = null;
        localPlayer = new LocalPlayer();
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                Board.pieces[x][y] = new Piece(Piece.PieceType.EMPTY).setPosition(x, y);
            }
        }
        Board.pieces[3][3] = new Piece(Piece.PieceType.BLOCK).setPosition(3, 3);
        Board.pieces[3][4] = new Piece(Piece.PieceType.BLOCK).setPosition(3, 4);
        Board.pieces[4][3] = new Piece(Piece.PieceType.BLOCK).setPosition(4, 3);
        Board.pieces[4][4] = new Piece(Piece.PieceType.BLOCK).setPosition(4, 4);
        setupContainer.initialize();
        autoFillButton.setEnabled(true);
        readyButton.setEnabled(false);
        saveButton.setEnabled(false);
        loadButton.setEnabled(true);
        selectedPiece = null;
        selectedTile = null;
        selectedButton = null;
    }

    private void autoFillBoard() {
        setupContainer.clear();
        ArrayList<Piece.PieceType> pieces2 = SetupContainer.getRemainingGamePieces(localPlayer);
        Collections.shuffle(pieces2);
        int flatMap = pieces2.size();
        for (int x = 0; x < 8; ++x) {
            for (int y = 5; y < 8; ++y) {
                if (!pieces[x][y].getPieceType().equals((Object)Piece.PieceType.EMPTY)) continue;
                Board.pieces[x][y] = new Piece((Piece.PieceType)((Object)pieces2.get(flatMap - 1))).setPosition(x, y);
                --flatMap;
            }
        }
        readyButton.setEnabled(true);
    }

    public static Piece getPiece(int col, int row) {
        return pieces[col][row];
    }

    public static void setPiece(int col, int row, Piece piece) {
        Board.pieces[col][row] = piece.setPosition(col, row);
    }

    public static void setPieces(List<Piece> list) {
        pieces = new Piece[8][8];
        Board.removeAllPieces();
        list.stream().forEach(i -> {
            Board.pieces[i.getColumn()][i.getRow()] = i.clone();
        });
    }

    public static void removeAllPieces() {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                Piece p = Board.getPiece(x, y);
                Board.pieces[x][y] = new Piece(Piece.PieceType.EMPTY).setPosition(x, y);
            }
        }
        Board.pieces[3][3] = new Piece(Piece.PieceType.BLOCK).setPosition(3, 3);
        Board.pieces[3][4] = new Piece(Piece.PieceType.BLOCK).setPosition(3, 4);
        Board.pieces[4][3] = new Piece(Piece.PieceType.BLOCK).setPosition(4, 3);
        Board.pieces[4][4] = new Piece(Piece.PieceType.BLOCK).setPosition(4, 4);
    }

    public static void movePiece(Piece piece, Piece dest) {
        if (Board.getCurrentPlayer().equals(enemyPlayer)) {
            Board.getEnemyPlayer().movePiece(piece, dest.getPosition());
        }
        Board.pieces[dest.getColumn()][dest.getRow()] = pieces[piece.getColumn()][piece.getRow()].clone().setPosition(dest.getPosition());
        Board.pieces[piece.getColumn()][piece.getRow()] = dest.clone().setPosition(piece.getPosition());
        Board.setLastMoveOnBoard(piece.getPosition(), GameLogic.getDirectionMove(piece, dest));
    }

    public static void addCapturedPiece(Piece.PieceType pieceType) {
        System.out.println("Captured " + (Object)((Object)pieceType));
        if (!capturedPieces.containsKey((Object)pieceType)) {
            capturedPieces.put(pieceType, 1);
        } else {
            capturedPieces.replace(pieceType, capturedPieces.get((Object)pieceType) + 1);
        }
    }

    public static void addLostPiece(Piece.PieceType pieceType) {
        System.out.println("Lost " + (Object)((Object)pieceType));
        if (!lostPieces.containsKey((Object)pieceType)) {
            lostPieces.put(pieceType, 1);
        } else {
            lostPieces.replace(pieceType, lostPieces.get((Object)pieceType) + 1);
        }
    }

    public static TurnState move(Piece start, Piece end2) {
        Piece end = Board.getPiece(end2.getColumn(), end2.getRow());
        if (end.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
            Board.movePiece(start, end);
            if (!Global.isNetworkGame() && Board.getCurrentOpposingPlayer().equals(Board.getEnemyPlayer())) {
                AIPlayer.updatetracker(start, end, AIPlayer.moveUpdate.MOVE);
            }
            selectedPiece = null;
            return Board.getCurrentPlayer().hasAtLeastOneMovablePiece() ? TurnState.VALID : TurnState.NO_MORE;
        }
        boolean attk = false;
        if (Global.isNetworkGame()) {
            attk = Board.getCurrentOpposingPlayer().hasPiece(end);
            System.out.println("Network enemy has piece: " + (Object)((Object)end.getPieceType()) + " | " + attk);
        } else {
            attk = Board.getCurrentOpposingPlayer().getPieces().contains(end);
        }
        if (attk) {
            boolean flag = GameLogic.attack(start, end);
            selectedPiece = null;
            if (flag) {
                return TurnState.FLAG_CAPTURED;
            }
            return Board.getCurrentPlayer().hasAtLeastOneMovablePiece() ? TurnState.VALID : TurnState.NO_MORE;
        }
        return TurnState.INVALID;
    }

    @Override
    public void processMousePressedEvent(MouseEvent e) {
        if (!Global.isGameOver()) {
            Stream.of(pieces).flatMap(Stream::of).forEach(i -> {
                if (i.getBounds().contains(e.getPoint())) {
                    if (Global.getBoardState().equals((Object)Global.BoardState.MY_TURN)) {
                        if (i.getPieceType().isSelectable()) {
                            if (selectedPiece == null) {
                                selectedPiece = i;
                            } else if (selectedPiece.equals(i)) {
                                selectedPiece = null;
                            }
                        } else if (selectedPiece != null && GameLogic.getMovableTiles(selectedPiece).contains(i)) {
                            e.consume();
                            TurnState result = Board.move(selectedPiece, i);
                            if (result.equals((Object)TurnState.VALID)) {
                                Global.getClient().sendPacketToServer("UPDATE_LOCAL." + SaveLoad.getPiecesAsString(Board.getLocalPlayer().getPieces()));
                                Global.getClient().sendPacketToServer("UPDATE_ENEMY." + SaveLoad.getPiecesAsString(enemyPlayer.getPieces()));
                                Global.getClient().sendPacketToServer("SWITCHTURNS");
                                if (!Global.isNetworkGame()) {
                                    Global.setBoardState(Global.BoardState.THEIR_TURN);
                                    new Thread(new ConditionalSleep(new Random().nextInt(3000) + 750){

                                        @Override
                                        public void call() {
                                            ((AIPlayer)enemyPlayer).nextMove();
                                        }

                                        @Override
                                        public boolean condition() {
                                            return false;
                                        }
                                    }).start();
                                }
                            } else if (result.equals((Object)TurnState.NO_MORE)) {
                                Global.setBoardState(Global.BoardState.GAME_LOSS);
                            } else if (result.equals((Object)TurnState.FLAG_CAPTURED)) {
                                if (Global.getBoardState().equals((Object)Global.BoardState.MY_TURN)) {
                                    Global.setBoardState(Global.BoardState.GAME_WON);
                                    Global.getClient().sendPacketToServer("GAME_WON");
                                } else {
                                    Global.setBoardState(Global.BoardState.GAME_LOSS);
                                    Global.getClient().sendPacketToServer("GAME_LOSS");
                                }
                            }
                        }
                    } else if (Global.getBoardState().equals((Object)Global.BoardState.SETUP) && selectedTile != null && i.getRow() > 4 && i.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
                        Board.pieces[i.getColumn()][i.getRow()] = new Piece(selectedTile.getType()).setPosition(i.getColumn(), i.getRow());
                        setupContainer.removeTile(selectedTile);
                        selectedTile = null;
                        if (setupContainer.getSetupTiles().isEmpty()) {
                            readyButton.setEnabled(true);
                            saveButton.setEnabled(true);
                        }
                    }
                }
            });
            if (Global.getBoardState().equals((Object)Global.BoardState.SETUP)) {
                for (SetupContainer.SetupTile tile : setupContainer.getSetupTiles()) {
                    if (!tile.getBounds().contains(e.getPoint())) continue;
                    if (selectedTile == null) {
                        selectedTile = tile;
                        continue;
                    }
                    if (!selectedTile.equals(tile)) continue;
                    selectedTile = null;
                }
                for (BoardButton button : this.setupButtons) {
                    if (!button.getBounds().contains(e.getPoint()) || !button.isEnabled()) continue;
                    if (button.equals(readyButton)) {
                        readyButton.setEnabled(false);
                        if (!Global.isNetworkGame()) {
                            enemyPlayer = new AIPlayer();
                            Board.addPieces(enemyPlayer.getSanitizedPieces());
                            Global.setBoardState(Global.BoardState.MY_TURN);
                            continue;
                        }
                        enemyPlayer = new NetworkPlayer();
                        Global.getClient().sendPacketToServer("SENDPIECES." + SaveLoad.getPiecesAsString());
                        continue;
                    }
                    if (button.equals(clearButton)) {
                        Board.initialize();
                        continue;
                    }
                    if (button.equals(autoFillButton)) {
                        this.autoFillBoard();
                        autoFillButton.setEnabled(false);
                        readyButton.setEnabled(true);
                        saveButton.setEnabled(true);
                        continue;
                    }
                    if (button.equals(saveButton)) {
                        SaveLoad.saveSetup();
                        loadButton.setEnabled(false);
                        continue;
                    }
                    if (button.equals(loadButton)) {
                        SaveLoad.loadSetup();
                        loadButton.setEnabled(false);
                        readyButton.setEnabled(true);
                        setupContainer.clear();
                        continue;
                    }
                    if (!button.equals(exitMainButton2)) continue;
                    Global.setGameState(Global.GameState.MENU);
                    Global.setBoardState(Global.BoardState.SETUP);
                }
            } else if (this.exitMainButton.getBounds().contains(e.getPoint()) && mainMenuButton.isEnabled()) {
                Global.setGameState(Global.GameState.MENU);
                Global.setBoardState(Global.BoardState.SETUP);
                Global.getClient().sendPacketToServer("REMOVE_CLIENT");
                Global.setGameType(false);
            }
        } else if (mainMenuButton.getBounds().contains(e.getPoint()) && mainMenuButton.isEnabled()) {
            Global.setGameState(Global.GameState.MENU);
            Global.setBoardState(Global.BoardState.SETUP);
            Global.getClient().sendPacketToServer("REMOVE_CLIENT");
            Global.setGameType(false);
        }
    }

    @Override
    public void processMouseMovedEvent(MouseEvent e) {
        if (Global.getBoardState().equals((Object)Global.BoardState.SETUP)) {
            for (BoardButton button : this.setupButtons) {
                if (button.getBounds().contains(e.getPoint())) {
                    button.setHighlighted(true);
                    continue;
                }
                button.setHighlighted(false);
            }
        } else if (Global.isGameOver()) {
            if (mainMenuButton.getBounds().contains(e.getPoint())) {
                mainMenuButton.setHighlighted(true);
            } else {
                mainMenuButton.setHighlighted(false);
            }
        } else if (this.exitMainButton.getBounds().contains(e.getPoint())) {
            this.exitMainButton.setHighlighted(true);
        } else {
            this.exitMainButton.setHighlighted(false);
        }
    }

    public void formatButton(Graphics g, BoardButton button) {
        if (button.isHighlighted()) {
            g.setColor(this.whiteTransparent);
        } else {
            g.setColor(this.blackTransparent);
        }
        g.fillRect(button.x, button.y, button.width, button.height);
        button.setFontMetrics(g.getFontMetrics(this.titleFont));
        if (button.isEnabled()) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(Color.RED);
        }
        g.drawString(button.getString(), button.getStringX(), button.getStringY());
    }

    private String formatEnum(String name) {
        return name.charAt(0) + name.toLowerCase().replace("_", " ").substring(1);
    }

    @Override
    public void paintScreen(Graphics g, ImageObserver o) {
        Graphics2D g2d = (Graphics2D)g;
        g.drawImage(Images.getImage("background_0"), 0, 0, o);
        List<Piece> pieces = GameLogic.getMovableTiles(selectedPiece);
        g2d.setColor(Color.WHITE);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                int xOffset = x * 64;
                int yOffset = y * 64;
                Piece piece = Board.getPiece(x, y);
                if (piece == null) {
                    return;
                }
                if (piece.getPieceType() != Piece.PieceType.EMPTY) {
                    if (piece.getPieceType().equals((Object)Piece.PieceType.GENERIC)) {
                        g.drawImage(Images.getImage("stone"), xOffset, yOffset, o);
                    } else if (piece.getPieceType().isSelectable() || piece.getPieceType().isPieceSpecial()) {
                        g.drawImage(Images.getImage("wood"), xOffset, yOffset, o);
                        if (piece.getPieceType().isSelectable()) {
                            g.setColor(Color.BLACK);
                            g.drawString(String.valueOf(piece.getPieceType().getCombatValue()), xOffset + 54, yOffset + 54);
                            g.setColor(Color.WHITE);
                            g.drawString(String.valueOf(piece.getPieceType().getCombatValue()), xOffset + 55, yOffset + 55);
                        }
                    }
                    if (piece.getPieceType().getSpriteIndex() > -1) {
                        g.drawImage(Images.getImage(String.valueOf(piece.getPieceType().getSpriteIndex())), xOffset, yOffset, o);
                    }
                } else if (Global.getBoardState().equals((Object)Global.BoardState.SETUP) && y > 4) {
                    g.setColor(this.yellowTransparent2);
                    g.fillRect(xOffset, yOffset, 64, 64);
                }
                if (piece.equals(selectedPiece)) {
                    if (piece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
                        g.setColor(Color.GREEN);
                    } else {
                        g.setColor(Color.RED);
                    }
                    g.drawRect(xOffset, yOffset, 62, 62);
                    g.drawRect(xOffset + 1, yOffset + 1, 62, 62);
                } else {
                    g2d.setColor(Color.WHITE);
                    g2d.drawRect(xOffset, yOffset, 64, 64);
                }
                if (!pieces.contains(piece)) continue;
                if (piece.getPieceType().equals((Object)Piece.PieceType.EMPTY)) {
                    g.setColor(this.greenTransparent);
                } else {
                    g.setColor(this.redTransparent);
                }
                g.fillRect(xOffset, yOffset, 64, 64);
            }
        }
        if (getLastMoveOnBoard != null && !Global.isNetworkGame()) {
            g.drawImage(Images.getImage(getLastDirectionOnBoard.getImage()), Board.getLastMoveOnBoard.x, Board.getLastMoveOnBoard.y, o);
        }
        if (Animation.shouldAnimate()) {
            g.setColor(this.redTransparent2);
            g.fillRect(Animation.getX() * 64, Animation.getY() * 64, 64, 64);
            g.drawImage(Images.getImage(String.valueOf(Animation.getAnimationIndex())), Animation.getX() * 64, Animation.getY() * 64, o);
        }
        g.setColor(this.blackTransparent);
        g.fillRect(0, 514, Global.WIDTH / 2 + 1, 260);
        g.fillRect(Global.WIDTH / 2 + 1, 0, Global.WIDTH / 2, Global.HEIGHT);
        if (Global.getBoardState().equals((Object)Global.BoardState.SETUP)) {
            g.setColor(Color.YELLOW);
            g.setFont(this.titleFont);
            g.drawString("Place your pieces on the board", 15, 544);
            for (SetupContainer.SetupTile tile : setupContainer.getSetupTiles()) {
                g.setColor(Color.YELLOW);
                g.drawRect(tile.x, tile.y, tile.width, tile.height);
                if (tile.equals(selectedTile)) {
                    g.setColor(this.yellowTransparent2);
                    g.fillRect(tile.x + 1, tile.y + 1, tile.width - 1, tile.height - 1);
                }
                g.drawImage(Images.getImage(String.valueOf(tile.getType().getSpriteIndex())), tile.x + setupContainer.getTileXOffset(), tile.y + setupContainer.getTileYOffset(), o);
                if (tile.getType().getCombatValue() <= 0) continue;
                g.drawString("" + tile.getType().getCombatValue(), tile.x + (tile.width - 15), tile.y + (tile.height - 12));
            }
            for (BoardButton button : this.setupButtons) {
                this.formatButton(g, button);
            }
        } else {
            g.setColor(Color.WHITE);
            g.drawLine(Global.WIDTH - Global.WIDTH / 4, 0, Global.WIDTH - Global.WIDTH / 4, Global.HEIGHT);
            g.drawLine(Global.WIDTH - Global.WIDTH / 2, 0, Global.WIDTH - Global.WIDTH / 2, Global.HEIGHT);
            g.setColor(Color.YELLOW);
            g.setFont(this.titleFont);
            g.drawString("Captured Pieces", Global.WIDTH - Global.WIDTH / 2 + 60, 35);
            int i = 0;
            for (Map.Entry<Piece.PieceType, Integer> p : capturedPieces.entrySet()) {
                g.drawImage(Images.getImage(String.valueOf(p.getKey().getSpriteIndex())), Global.WIDTH - Global.WIDTH / 2 + 45, 60 + (i * 64 + 16), o);
                g.drawString("x" + p.getValue(), Global.WIDTH - Global.WIDTH / 2 + 45 + 64, 60 + (i * 64 + 16) + 32);
                ++i;
            }
            i = 0;
            g.drawString("Lost Pieces", Global.WIDTH - Global.WIDTH / 4 + 70, 35);
            for (Map.Entry<Piece.PieceType, Integer> p : lostPieces.entrySet()) {
                g.drawImage(Images.getImage(String.valueOf(p.getKey().getSpriteIndex())), Global.WIDTH - Global.WIDTH / 4 + 45, 60 + (i * 64 + 16), o);
                g.drawString("x" + p.getValue(), Global.WIDTH - Global.WIDTH / 4 + 45 + 64, 60 + (i * 64 + 16) + 32);
                ++i;
            }
            if (selectedPiece != null) {
                g.setColor(Color.YELLOW);
                g.setFont(this.titleFont);
                g.drawString("Selected Piece: " + this.formatEnum(selectedPiece.getPieceType().name()), 15, 575);
                if (selectedPiece.getPieceType().hasInfo()) {
                    g.drawString("Special: " + selectedPiece.getPieceType().getInfo(), 15, 600);
                }
            }
            g.drawString("Turn: " + (Global.getBoardState().equals((Object)Global.BoardState.MY_TURN) ? "My Turn" : "Enemy turn"), 15, 550);
            if (Global.isGameOver()) {
                g.setColor(this.blackTransparent);
                g.fillRect(0, 0, Global.WIDTH, Global.HEIGHT);
                g.fillRect(Global.WIDTH / 4, Global.HEIGHT / 4, Global.WIDTH / 2, Global.HEIGHT / 2);
                g.setColor(Color.YELLOW);
                g.drawString(Global.getBoardState().name().replace("_", " ") + "!", 465, 250);
                this.formatButton(g, mainMenuButton);
            } else {
                this.formatButton(g, this.exitMainButton);
            }
        }
    }

    static {
        setupContainer = new SetupContainer(15, 560, Global.WIDTH - 31, 160);
        pieces = new Piece[8][8];
    }

    public static enum TurnState {
        VALID,
        INVALID,
        NO_MORE,
        FLAG_CAPTURED;

    }

    public static enum Direction {
        UP(-1, "arrow_up"),
        DOWN(1, "arrow_down"),
        LEFT(-1, "arrow_left"),
        RIGHT(1, "arrow_right");

        int offset;
        String image;

        private Direction(int offset, String image) {
            this.offset = offset;
            this.image = image;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getImage() {
            return this.image;
        }
    }
}

