/*
 * Decompiled with CFR 0.152.
 */
package client.screens;

import client.Global;
import client.resources.Images;
import client.resources.Sound;
import client.screens.MenuButton;
import client.screens.Screen;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;

public class MainMenu
implements Screen {
    public Rectangle closeButton = new Rectangle(625, 375, 25, 25);
    public MenuButton button_pvp = new MenuButton("Play vs Player", 350, 300, 300, 50);
    public MenuButton button_ai = new MenuButton("Play vs AI", 350, 400, 300, 50);
    public MenuButton button_quit = new MenuButton("Exit Game", 350, 500, 300, 50);
    public static MenuButton buttonPressed = null;
    public static MenuButton buttonHovered = null;
    public Color hoverColor = new Color(81, 28, 0, 80);
    public Color darkGreen = new Color(40, 15, 0, 80);
    public Color blackTransparent = new Color(0, 0, 0, 225);
    private String searchStatus = "";
    Font pvpTextFont = new Font("Sans-Serif", 0, 15);
    Font font = new Font("Sans-Serif", 1, 25);

    @Override
    public void processMouseMovedEvent(MouseEvent e) {
        buttonHovered = null;
        if (this.button_pvp.getBounds().contains(e.getPoint())) {
            buttonHovered = this.button_pvp;
        } else if (this.button_quit.getBounds().contains(e.getPoint())) {
            buttonHovered = this.button_quit;
        } else if (this.button_ai.getBounds().contains(e.getPoint())) {
            buttonHovered = this.button_ai;
        }
    }

    @Override
    public void paintScreen(Graphics g, ImageObserver o) {
        this.button_pvp.setFontMetrics(g.getFontMetrics(this.font));
        this.button_ai.setFontMetrics(g.getFontMetrics(this.font));
        this.button_quit.setFontMetrics(g.getFontMetrics(this.font));
        Graphics2D g2d = (Graphics2D)g;
        g.drawImage(Images.getImage("background_1"), 0, 0, o);
        g.drawImage(Images.getImage("logo"), 185, 130, o);
        g2d.setColor(this.darkGreen);
        g2d.fillRect((int)this.button_pvp.getX(), (int)this.button_pvp.getY(), (int)this.button_pvp.getWidth(), (int)this.button_pvp.getHeight());
        g2d.fillRect((int)this.button_ai.getX(), (int)this.button_ai.getY(), (int)this.button_ai.getWidth(), (int)this.button_ai.getHeight());
        g2d.fillRect((int)this.button_quit.getX(), (int)this.button_quit.getY(), (int)this.button_quit.getWidth(), (int)this.button_quit.getHeight());
        if (this.button_pvp.equals(buttonHovered)) {
            g2d.setColor(this.hoverColor);
            g2d.fillRect((int)this.button_pvp.getX(), (int)this.button_pvp.getY(), (int)this.button_pvp.getWidth(), (int)this.button_pvp.getHeight());
        } else if (this.button_ai.equals(buttonHovered)) {
            g2d.setColor(this.hoverColor);
            g2d.fillRect((int)this.button_ai.getX(), (int)this.button_ai.getY(), (int)this.button_ai.getWidth(), (int)this.button_ai.getHeight());
        } else if (this.button_quit.equals(buttonHovered)) {
            g2d.setColor(this.hoverColor);
            g2d.fillRect((int)this.button_quit.getX(), (int)this.button_quit.getY(), (int)this.button_quit.getWidth(), (int)this.button_quit.getHeight());
        }
        g2d.setColor(Color.BLACK);
        g2d.setFont(this.font);
        g2d.drawString(this.button_pvp.getText(), this.button_pvp.getStringX(), this.button_pvp.getStringY());
        g2d.drawString(this.button_ai.getText(), this.button_ai.getStringX(), this.button_ai.getStringY());
        g2d.drawString(this.button_quit.getText(), this.button_quit.getStringX(), this.button_quit.getStringY());
        g2d.setColor(Color.WHITE);
        g2d.drawString(this.button_pvp.getText(), this.button_pvp.getStringX() + 2, this.button_pvp.getStringY() + 2);
        g2d.drawString(this.button_ai.getText(), this.button_ai.getStringX() + 2, this.button_ai.getStringY() + 2);
        g2d.drawString(this.button_quit.getText(), this.button_quit.getStringX() + 2, this.button_quit.getStringY() + 2);
        if (this.button_pvp.equals(buttonPressed)) {
            MenuButton searchMenu = new MenuButton(this.searchStatus, 350, 375, 300, 200);
            g2d.setFont(new Font("Sans-Serif", 0, 15));
            g2d.setColor(this.blackTransparent);
            g2d.fillRect((int)searchMenu.getX(), (int)searchMenu.getY(), (int)searchMenu.getWidth(), (int)searchMenu.getHeight());
            searchMenu.setFontMetrics(g.getFontMetrics(this.pvpTextFont));
            g2d.setColor(Color.WHITE);
            this.searchStatus = "Searching for a player...";
            g2d.drawString(this.searchStatus, searchMenu.getStringX(), searchMenu.getStringY());
            g.drawImage(Images.getImage("close_background_"), 0, 0, o);
            g2d.drawImage(Images.loadImage("closeicon"), this.closeButton.x, this.closeButton.y, this.closeButton.width, this.closeButton.height, o);
        }
    }

    @Override
    public void processMousePressedEvent(MouseEvent e) {
        if (this.button_pvp.getBounds().contains(e.getPoint()) && (buttonPressed == null || buttonPressed == this.button_pvp)) {
            Clip clip = Sound.loadSound("buttonclickon");
            clip.setMicrosecondPosition(0L);
            String server = JOptionPane.showInputDialog(null, "Enter server ip address: ", "localhost");
            if (server != null) {
                Global.getClient().setServer(server);
                buttonPressed = this.button_pvp;
                if (Global.getClient().connect()) {
                    Global.getClient().sendPacketToServer("QUEUEPLAYER");
                } else {
                    this.searchStatus = "Failed to connect to the server";
                }
            } else {
                this.searchStatus = "Please enter a valid server address";
            }
        } else if (this.button_ai.getBounds().contains(e.getPoint()) && (buttonPressed == null || buttonPressed.equals(this.button_ai))) {
            Global.setGameType(false);
            Global.setGameState(Global.GameState.GAME);
            buttonPressed = this.button_ai;
            Clip clip = Sound.loadSound("buttonclickon");
            clip.setMicrosecondPosition(0L);
        } else if (this.button_quit.getBounds().contains(e.getPoint()) && (buttonPressed == null || buttonPressed.equals(this.button_quit))) {
            if (Global.getClient().isConnected()) {
                Global.getClient().sendPacketToServer("REMOVE_CLIENT");
                Global.getClient().disconnect();
            }
            System.exit(0);
        } else if (this.closeButton.getBounds().contains(e.getPoint()) && buttonPressed.equals(this.button_pvp)) {
            Clip clip = Sound.loadSound("buttonclickoff");
            clip.setMicrosecondPosition(0L);
            if (Global.getClient().isConnected()) {
                Global.getClient().sendPacketToServer("REMOVEPLAYER");
            }
            buttonPressed = null;
        }
    }
}

