/*
 * Decompiled with CFR 0.152.
 */
package client.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound {
    public static Map<String, Clip> soundCache = new HashMap<String, Clip>();

    public static void initialize() {
        Sound.loadSound("buttonclickon.wav");
        Sound.loadSound("buttonclickoff.wav");
    }

    public static Clip getSound(String name) {
        return soundCache.get(name);
    }

    public static Clip loadSound(String fileName) {
        if (soundCache.containsKey(fileName)) {
            return soundCache.get(fileName);
        }
        try {
            InputStream soundInputStream = Sound.class.getResourceAsStream("audio/" + fileName);
            AudioInputStream sound = AudioSystem.getAudioInputStream(new BufferedInputStream(soundInputStream));
            Clip clip = AudioSystem.getClip();
            clip.open(sound);
            soundCache.put(fileName.split("\\.")[0], clip);
            return clip;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
            return null;
        }
    }
}

