/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Global;
import client.screens.MainMenu;
import game.Board;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class SPanel
extends JPanel
implements ActionListener {
    private MainMenu mainMenu;
    private Board board = new Board();

    public SPanel() {
        this.mainMenu = new MainMenu();
        this.addKeyListener(new AAdapter());
        BAdapter b = new BAdapter();
        this.addMouseListener(b);
        this.addMouseMotionListener(b);
        this.setFocusable(true);
        this.setBackground(Color.BLACK);
        this.setDoubleBuffered(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        switch (Global.getGameState()) {
            case MENU: {
                this.mainMenu.paintScreen(g, this);
                break;
            }
            case GAME: {
                this.board.paintScreen(g, this);
                break;
            }
            default: {
                this.mainMenu.paintScreen(g, this);
            }
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    private class BAdapter
    extends MouseAdapter {
        private BAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            switch (Global.getGameState()) {
                case MENU: {
                    SPanel.this.mainMenu.processMouseMovedEvent(e);
                    break;
                }
                case GAME: {
                    SPanel.this.board.processMouseMovedEvent(e);
                }
            }
            SPanel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            switch (Global.getGameState()) {
                case MENU: {
                    SPanel.this.mainMenu.processMousePressedEvent(e);
                    break;
                }
                case GAME: {
                    SPanel.this.board.processMousePressedEvent(e);
                }
            }
            SPanel.this.repaint();
        }
    }

    private class AAdapter
    extends KeyAdapter {
        private AAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

