/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Global;
import game.Board;
import game.Piece;
import game.SaveLoad;
import game.player.NetworkPlayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;

public class Network
implements Runnable {
    public int PORT;
    public boolean DEBUG = true;
    public String SERVER;
    public ArrayList<String> commands = new ArrayList();
    private DataInputStream dIn = null;
    private DataOutputStream dOut = null;
    private Socket clientConnection = null;
    private String clientAddress;
    private boolean connected = false;
    private String answer = "";
    private int connectedPlayers = 0;
    private boolean started = false;

    public Network(int port, String server) {
        this.PORT = port;
        this.SERVER = server;
    }

    public void setServer(String s) {
        this.SERVER = s;
    }

    public void debug(String s) {
        if (this.DEBUG) {
            String timeStamp = new SimpleDateFormat("hh:mm:ss").format(new Date());
            System.out.println("\t[" + timeStamp + "]: " + s);
        }
    }

    public int getConnectedPlayers() {
        return this.connectedPlayers;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean connect() {
        if (this.connected) {
            return true;
        }
        this.dIn = null;
        this.dOut = null;
        this.clientConnection = null;
        this.connected = false;
        try {
            System.out.println("Attempting to connected to " + this.SERVER + " on port " + this.PORT);
            this.clientConnection = new Socket(this.SERVER, this.PORT);
            this.clientAddress = this.clientConnection.getLocalAddress().toString();
            System.out.println("Successfully connected client [" + this.clientAddress + "] to server. Sending message now");
            OutputStream out = this.clientConnection.getOutputStream();
            this.dOut = new DataOutputStream(out);
            InputStream in = this.clientConnection.getInputStream();
            this.dIn = new DataInputStream(in);
        }
        catch (IOException e) {
            System.out.println("Failed to connect to " + this.SERVER + ":" + this.PORT);
            return false;
        }
        this.connected = true;
        Global.setGameType(true);
        return this.clientConnection != null;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void disconnect() {
        this.connected = false;
    }

    @Override
    public void run() {
        while (true) {
            if (this.connected) {
                try {
                    InputStream in = this.clientConnection.getInputStream();
                    this.dIn = new DataInputStream(in);
                    this.handleIncomingPacket(this.dIn.readUTF());
                }
                catch (SocketException e) {
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void sendPacketToServer(String s) {
        if (!Global.isNetworkGame()) {
            return;
        }
        if (this.clientConnection.isClosed() || !this.clientConnection.isConnected()) {
            return;
        }
        if (this.clientConnection == null) {
            return;
        }
        DataOutputStream dOut = null;
        try {
            dOut = new DataOutputStream(this.clientConnection.getOutputStream());
            if (dOut != null) {
                dOut.writeUTF(s);
                dOut.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handleIncomingPacket(String s) {
        if (s.startsWith("GIVINGPIECES")) {
            s = s.substring("GIVINGPIECES".length() + 1, s.length());
            NetworkPlayer np = (NetworkPlayer)Board.getEnemyPlayer();
            np.setPieces(SaveLoad.convertPieces(s));
            Board.addPieces(np.getSanitizedPieces());
            return;
        }
        if (s.startsWith("UPDATE_ENEMY")) {
            s = s.substring("UPDATE_ENEMY".length() + 1, s.length());
            ((NetworkPlayer)Board.getEnemyPlayer()).setPieces(SaveLoad.convertPieces(s));
            return;
        }
        if (s.startsWith("REMOVE_LOCAL_PIECE")) {
            s = s.substring("REMOVE_LOCAL_PIECE".length() + 1, s.length());
            System.out.println("attempting to remove: " + s);
            if (s.length() == 3) {
                System.out.println("fuck this");
                String rx = Character.toString(s.charAt(0));
                String ry = Character.toString(s.charAt(2));
                int x = Integer.parseInt(rx);
                int y = Integer.parseInt(ry);
                System.out.println("Removing piece (" + x + ", " + y + ")");
                Board.getLocalPlayer().removePiece(Board.getPiece(x, y));
            }
            return;
        }
        if (s.startsWith("SEND_CAPTURED")) {
            System.out.println("Received captured piece: " + s);
            s = s.substring("SEND_CAPTURED".length() + 1, s.length());
            for (Piece.PieceType type : Piece.PieceType.values()) {
                if (!s.equals(type.name())) continue;
                Board.addCapturedPiece(type);
                break;
            }
            return;
        }
        switch (s) {
            case "INSETUP": {
                Global.setBoardState(Global.BoardState.SETUP);
                Global.setGameState(Global.GameState.GAME);
                System.out.println("Set gamestate");
                this.sendPacketToServer("STATUS_SETUP");
                break;
            }
            case "INGAME": {
                Global.setBoardState(Global.BoardState.MY_TURN);
                Global.setBoardState(Global.BoardState.THEIR_TURN);
                System.out.println("Set gamestate to in game");
                this.sendPacketToServer("STATUS_GAME");
                break;
            }
            case "YOURTURN": {
                Global.setBoardState(Global.BoardState.MY_TURN);
                break;
            }
            case "THEIRTURN": {
                Global.setBoardState(Global.BoardState.THEIR_TURN);
                break;
            }
            case "GAME_WON": {
                Global.setBoardState(Global.BoardState.GAME_WON);
                break;
            }
            case "GAME_LOSS": {
                Global.setBoardState(Global.BoardState.GAME_LOSS);
                break;
            }
            case "DC": {
                this.disconnect();
                Global.getClient().sendPacketToServer("REMOVE_CLIENT");
                Global.setGameType(false);
                break;
            }
            case "OPP_DC": {
                this.disconnect();
                Global.setGameState(Global.GameState.MENU);
                Global.setBoardState(Global.BoardState.SETUP);
                Global.getClient().sendPacketToServer("DC");
                JOptionPane.showMessageDialog(null, "Opponent has disconnected!", "Connection to your opponent has been lost.", 1);
                Global.setGameType(false);
                break;
            }
            case "SEND_BOARD": {
                ArrayList<Piece> pieces = new ArrayList<Piece>();
                pieces.addAll(Board.getEnemyPlayer().getSanitizedPieces());
                pieces.addAll(Board.getLocalPlayer().getPieces());
                Board.setPieces(pieces);
                break;
            }
            default: {
                System.out.println("Unknown request from server: " + s);
            }
        }
    }

    public String getAnswer() {
        return this.answer;
    }
}

