/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Network;
import client.screens.MainMenu;
import game.Board;

public class Global {
    public static int WIDTH = 1024;
    public static int HEIGHT = 768;
    private static GameState gameState = GameState.MENU;
    private static BoardState boardState = BoardState.MY_TURN;
    public static Network connectedServer;
    private static boolean networkGame;

    public static GameState getGameState() {
        return gameState;
    }

    public static void setGameState(GameState state) {
        if (state.equals((Object)GameState.GAME)) {
            boardState = BoardState.SETUP;
            Board.initialize();
            Board.capturedPieces.clear();
            Board.lostPieces.clear();
        } else if (state.equals((Object)GameState.MENU)) {
            MainMenu.buttonHovered = null;
            MainMenu.buttonPressed = null;
        }
        gameState = state;
    }

    public static BoardState getBoardState() {
        return boardState;
    }

    public static void setBoardState(BoardState state) {
        boardState = state;
    }

    public static boolean isGameOver() {
        return boardState.equals((Object)BoardState.GAME_LOSS) || boardState.equals((Object)BoardState.GAME_WON);
    }

    public static void setServer(Network serve) {
        connectedServer = serve;
    }

    public static Network getServer() {
        return connectedServer;
    }

    public static void setGameType(boolean network) {
        networkGame = network;
    }

    public static boolean isNetworkGame() {
        return networkGame;
    }

    public static Network getClient() {
        return connectedServer;
    }

    static {
        networkGame = false;
    }

    public static enum GameState {
        GAME,
        MENU,
        CREDITS;

    }

    public static enum BoardState {
        SETUP,
        MY_TURN,
        THEIR_TURN,
        GAME_WON,
        GAME_LOSS;

    }
}

