/*
 * Decompiled with CFR 0.152.
 */
import client.Global;
import client.Network;
import client.SPanel;
import client.resources.Images;
import client.resources.Sound;
import game.Board;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ClientDriver
extends JFrame {
    public static int PORT = 22344;
    public static String SERVER = "localhost";
    public static SPanel sPanel = new SPanel();

    public ClientDriver() {
        Global.setBoardState(Global.BoardState.SETUP);
        Board.initialize();
        Images.initialize();
        Sound.initialize();
        this.add(sPanel);
        this.setTitle("Stratego 2442");
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setSize(Global.WIDTH, Global.HEIGHT);
        this.setVisible(true);
        this.setIconImages(Images.getIcons());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ClientDriver();
                Global.connectedServer = new Network(PORT, SERVER);
                new Thread(Global.connectedServer).start();
                new Thread(new Runnable(){
                    public long update = System.currentTimeMillis();

                    @Override
                    public void run() {
                        while (true) {
                            if (System.currentTimeMillis() - this.update > 100L) {
                                sPanel.repaint();
                                this.update = System.currentTimeMillis();
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                }).start();
            }
        });
    }
}

