/*
 * Decompiled with CFR 0.152.
 */
package main.levels;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.List;
import main.Global;
import main.entities.Entity;
import main.entities.NonSolidEntity;
import main.entities.SolidEntity;
import main.levels.Levels;

public class Level_Handler {
    public static void load() {
        if (Level_Handler.getMapInputStream() != null) {
            try {
                String getLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(Level_Handler.getMapInputStream()));
                while ((getLine = reader.readLine()) != null) {
                    if (getLine.isEmpty()) continue;
                    String[] line = getLine.split(",");
                    Level_Handler.addEntity(Integer.parseInt(line[0]), Integer.parseInt(line[1]), line[2], Integer.parseInt(line[3]), Integer.parseInt(line[4]));
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        if (Level_Handler.getMapInputStream() != null) {
            try {
                List<Entity> entities = Levels.getLevel().getEntities();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Level_Handler.getMapOutputStream()));
                for (int i = 0; i < entities.size(); ++i) {
                    writer.write(entities.get(i).getEntityType() + "," + entities.get(i).getChildId() + "," + entities.get(i).getImageLocation() + "," + entities.get(i).getX() + "," + entities.get(i).getY());
                    writer.newLine();
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addEntity(int type, int child, String image, int x, int y) {
        switch (type) {
            case 1: {
                Levels.getLevel().getEntities().add(new SolidEntity(x, y, image, child));
                break;
            }
            case 2: {
                Levels.getLevel().getEntities().add(new NonSolidEntity(x, y, image, child));
            }
        }
        Global.setInterface(null);
        Global.setFocus(Global.Focus.CONTROLLER);
    }

    private static InputStream getMapInputStream() {
        return Level_Handler.class.getResourceAsStream("/main/levels/maps/Level_" + Global.getGameLevel() + ".txt");
    }

    private static OutputStream getMapOutputStream() {
        try {
            return new FileOutputStream(new File(Level_Handler.class.getResource("/main/levels/maps/Level_" + Global.getGameLevel() + ".txt").toURI()));
        }
        catch (FileNotFoundException | URISyntaxException e) {
            return null;
        }
    }
}

