/*
 * Decompiled with CFR 0.152.
 */
package main.levels;

import java.util.ArrayList;
import java.util.List;
import main.controllers.Controller;
import main.entities.Entity;

public abstract class Level {
    List<Entity> entities = new ArrayList<Entity>();
    Controller controller;

    public Level(Controller controller) {
        this.controller = controller;
    }

    public abstract void initEntities();

    public List<Entity> getEntities() {
        return this.entities;
    }

    public boolean contains(String entityName) {
        for (Entity e : this.entities) {
            if (!e.getImageLocation().equalsIgnoreCase(entityName)) continue;
            return true;
        }
        return false;
    }

    public Controller getController() {
        return this.controller;
    }

    public void clearEntitiesWithName(String name) {
        ArrayList<Entity> entityStorage = new ArrayList<Entity>();
        for (Entity e : this.entities) {
            if (!e.getImageLocation().contains(name)) continue;
            entityStorage.add(e);
        }
        this.entities.removeAll(entityStorage);
    }

    public void removeEntity(Entity entity) {
        this.entities.remove(entity);
    }

    public Entity getEntityForId(int id) {
        for (Entity e : this.entities) {
            if (e.getChildId() != id) continue;
            return e;
        }
        return null;
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }
}

