/*
 * Decompiled with CFR 0.152.
 */
package main.inventory;

import java.util.ArrayList;
import java.util.List;
import main.inventory.Slot;

public class Inventory {
    private static List<Slot> slots = new ArrayList<Slot>();
    private static final int baseX = 256;
    private static final int baseY = 124;

    public static void initialize() {
        for (int i = 0; i < 4; ++i) {
            slots.add(new Slot(i + 1, 256, 124 + 32 * i + i));
        }
    }

    public static Slot getSlot(int slot) {
        return slots.get(slot - 1);
    }

    public static void clear() {
        for (Slot slot : slots) {
            slot.reset();
        }
    }

    public static List<Slot> getSlots() {
        return slots;
    }

    public static boolean contains(String ... items) {
        for (Slot slot : slots) {
            for (String item : items) {
                if (slot.getItem() == null || !slot.getItem().equalsIgnoreCase(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addItem(String item) {
        for (Slot slot : slots) {
            if (slot.getItem() != null) continue;
            slot.setItem(item);
            break;
        }
    }

    public static void removeItem(String item) {
        for (int i = 0; i < slots.size(); ++i) {
            if (!slots.get(i).getItem().equalsIgnoreCase(item)) continue;
            Slot slot = slots.get(i);
            slots.set(i, new Slot(slot.getId(), slot.getX(), slot.getY()));
            break;
        }
    }

    public static boolean isFull() {
        for (Slot slot : slots) {
            if (slot.getItem() != null) continue;
            return false;
        }
        return true;
    }
}

