/*
 * Decompiled with CFR 0.152.
 */
package main.interfaces;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import main.Global;
import main.entities.Entity;
import main.levels.Levels;
import main.resources.Images;

public class Sprite_Selector {
    public Sprite_Selector() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(410, 300));
        SpringLayout layout = new SpringLayout();
        JFrame frame = new JFrame("Sprite Selector - Written by Aleksander Krimsky");
        frame.setDefaultCloseOperation(2);
        frame.add(tabbedPane);
        frame.setResizable(false);
        File filePath = new File("src/main/resources/images");
        for (File file : filePath.listFiles()) {
            if (!file.isDirectory()) continue;
            ArrayList<String> strings = new ArrayList<String>();
            JPanel panel = new JPanel(false);
            tabbedPane.addTab(file.getName(), null, panel);
            panel.setLayout(layout);
            for (File image : file.listFiles()) {
                String imageDir = file.getName() + "/" + image.getName();
                Images.loadImage(imageDir);
                strings.add(imageDir);
            }
            final JList<String> listFinal = new JList<String>(Sprite_Selector.convertStrings(strings));
            JScrollPane scrollPane = new JScrollPane(listFinal, 22, 31);
            scrollPane.setPreferredSize(new Dimension(250, 250));
            ListSelectionListener listListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String s = listFinal.getSelectedValue().toString();
                    Levels.getLevel().getController().setImage(Images.loadImage(s));
                    Global.imageLocation = s;
                }
            };
            listFinal.addListSelectionListener(listListener);
            JButton objectButton = new JButton("Toggle solids");
            JButton itemButton = new JButton("Toggle non-solids");
            JButton childButton = new JButton("Toggle childs");
            JButton preciseButton = new JButton("Toggle precision");
            JButton resetButton = new JButton("Reset coords");
            objectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Entity entity : Levels.getLevel().getEntities()) {
                        if (!entity.isSolid()) continue;
                        entity.setVisible(!entity.isVisible());
                    }
                }
            });
            itemButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Entity entity : Levels.getLevel().getEntities()) {
                        if (entity.isSolid()) continue;
                        entity.setVisible(!entity.isVisible());
                    }
                }
            });
            childButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Global.showChild(!Global.isShowingChild());
                }
            });
            preciseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Global.TILE_OFFSET = Global.TILE_OFFSET == 1 ? 16 : 1;
                }
            });
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Levels.getLevel().getController().setX(0);
                    Levels.getLevel().getController().setY(0);
                }
            });
            this.guiBoxAdd(scrollPane, 0, 0, panel, layout);
            this.guiBoxAdd(objectButton, 255, 10, panel, layout);
            this.guiBoxAdd(itemButton, 255, 40, panel, layout);
            this.guiBoxAdd(childButton, 255, 70, panel, layout);
            this.guiBoxAdd(preciseButton, 255, 100, panel, layout);
            this.guiBoxAdd(resetButton, 255, 130, panel, layout);
        }
        frame.setVisible(true);
        frame.pack();
    }

    private void guiBoxAdd(JComponent jComponent, int x, int y, JComponent panel, SpringLayout layout) {
        panel.add(jComponent);
        layout.putConstraint("West", (Component)jComponent, x, "West", (Component)panel);
        layout.putConstraint("North", (Component)jComponent, y, "North", (Component)panel);
    }

    public static String[] convertStrings(List<String> strings) {
        String[] ret = new String[strings.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = strings.get(i);
        }
        return ret;
    }
}

