/*
 * Decompiled with CFR 0.152.
 */
package main.entities;

import java.awt.Image;
import java.awt.Rectangle;
import main.events.Action;
import main.resources.Images;

public abstract class Entity {
    private int x;
    private int y;
    private int width;
    private int height;
    private String imageLocation;
    private int entityType;
    private int childId;
    private Image image;
    private boolean visible;
    private Action action;

    public Entity(int x, int y, String imageLocation, int entityType, int childId) {
        this.x = x;
        this.y = y;
        this.imageLocation = imageLocation;
        if (imageLocation != null) {
            this.image = Images.loadImage(imageLocation);
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        this.entityType = entityType;
        this.childId = childId;
        this.visible = true;
        if (this.isInteractable()) {
            Action actionClass = null;
            try {
                actionClass = (Action)Action.class.cast(Class.forName("main.events.actions.Action_" + this.getChildId()).newInstance());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                System.out.println("Could not load class: main.events.actions.Action_" + this.getChildId());
            }
            if (actionClass != null) {
                this.action = actionClass;
                System.out.println("Loaded action class: " + actionClass.toString());
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void updateImage(String location) {
        this.imageLocation = location;
        this.image = Images.loadImage(this.imageLocation);
    }

    public int getEntityType() {
        return this.entityType;
    }

    public int getChildId() {
        return this.childId;
    }

    public void setChildId(int childId) {
        this.childId = childId;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public void setImage(Image image) {
        this.image = image;
        this.setWidth(image.getWidth(null));
        this.setHeight(image.getHeight(null));
    }

    public abstract boolean isSolid();

    public boolean isInteractable() {
        return this.childId > 0;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public void setEntityType(int type) {
        this.entityType = type;
    }
}

