/*
 * Decompiled with CFR 0.152.
 */
package main.controllers;

import java.awt.Image;
import java.awt.event.KeyEvent;
import main.Global;
import main.controllers.Controller;
import main.entities.Entity;
import main.entities.MenuTrack;
import main.levels.Levels;

public class Selector
extends Controller {
    private boolean canMove = true;

    public Selector(int x, int y, Image image) {
        super(x, y, image);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.canMove) {
            switch (e.getKeyCode()) {
                case 38: {
                    super.setDy(-Global.TILE_OFFSET);
                    this.canMove = false;
                    this.checkMovement();
                    break;
                }
                case 40: {
                    super.setDy(Global.TILE_OFFSET);
                    this.canMove = false;
                    this.checkMovement();
                    break;
                }
                case 90: {
                    for (Entity entity : Levels.getLevel().getEntities()) {
                        if (!(entity instanceof MenuTrack) || !entity.getBounds().contains(super.getX(), super.getY()) || ((MenuTrack)entity).getLabel() == null) continue;
                        switch (((MenuTrack)entity).getLabel()) {
                            case "Start": {
                                Levels.setLevel(1);
                                break;
                            }
                            case "Credits": {
                                Levels.setLevel(101);
                                break;
                            }
                            case "Exit": {
                                System.out.println("Exit");
                                System.exit(0);
                                break;
                            }
                            case "Main Menu": {
                                Levels.setLevel(100);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.canMove = true;
            }
        }
    }

    private void checkMovement() {
        int Dx = super.getX() + super.getDx();
        int Dy = super.getY() + super.getDy();
        for (Entity e : Levels.getLevel().getEntities()) {
            if (!(e instanceof MenuTrack) || !e.getBounds().contains(Dx, Dy)) continue;
            this.move();
            super.setDx(0);
            super.setDy(0);
            break;
        }
    }
}

