/*
 * Decompiled with CFR 0.152.
 */
package main.controllers;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import main.Board;
import main.Global;
import main.controllers.Controller;
import main.entities.Entity;
import main.interfaces.Option_Interface;
import main.levels.Levels;
import main.resources.Images;

public class Player
extends Controller {
    private boolean canMove = true;
    private Facing facing = Facing.UP;
    private Action action = Action.IDLE;

    public Player(int x, int y, Image image) {
        super(x, y, image);
    }

    private void setFacing(Facing facing) {
        this.facing = facing;
        switch (facing) {
            case LEFT: {
                super.setImage(Images.loadImage("characters/player_left.png"));
                break;
            }
            case RIGHT: {
                super.setImage(Images.loadImage("characters/player_right.png"));
                break;
            }
            case UP: {
                super.setImage(Images.loadImage("characters/player_up.png"));
                break;
            }
            case DOWN: {
                super.setImage(Images.loadImage("characters/player_down.png"));
            }
        }
    }

    private void refresh() {
        super.setDx(0);
        super.setDy(0);
        if (this.action.equals((Object)Action.INTERACT)) {
            this.canMove = true;
        }
        this.action = Action.IDLE;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean check = true;
        if (this.canMove) {
            int key = e.getKeyCode();
            switch (key) {
                case 37: {
                    this.setFacing(Facing.LEFT);
                    super.setDx(-Global.TILE_OFFSET);
                    this.action = Action.MOVE;
                    break;
                }
                case 39: {
                    this.setFacing(Facing.RIGHT);
                    super.setDx(Global.TILE_OFFSET);
                    this.action = Action.MOVE;
                    break;
                }
                case 38: {
                    this.setFacing(Facing.UP);
                    super.setDy(-Global.TILE_OFFSET);
                    this.action = Action.MOVE;
                    break;
                }
                case 40: {
                    this.setFacing(Facing.DOWN);
                    super.setDy(Global.TILE_OFFSET);
                    this.action = Action.MOVE;
                    break;
                }
                case 90: {
                    switch (this.facing) {
                        case LEFT: {
                            super.setDx(-Global.TILE_OFFSET);
                            break;
                        }
                        case RIGHT: {
                            super.setDx(Global.TILE_OFFSET);
                            break;
                        }
                        case UP: {
                            super.setDy(-Global.TILE_OFFSET);
                            break;
                        }
                        case DOWN: {
                            super.setDy(Global.TILE_OFFSET);
                        }
                    }
                    this.action = Action.INTERACT;
                    break;
                }
                case 120: {
                    Levels.setLevel(99);
                    break;
                }
                case 69: {
                    Levels.setLevel(3);
                    break;
                }
                case 27: {
                    Levels.setLevel(100);
                    break;
                }
                default: {
                    check = false;
                }
            }
        }
        if (check) {
            this.checkCollisions();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.canMove = true;
            }
        }
    }

    private void checkCollisions() {
        this.canMove = false;
        boolean execute = true;
        int Dx = super.getX() + super.getDx();
        int Dy = super.getY() + super.getDy();
        Rectangle bounds = new Rectangle(Dx, Dy, 16, 16);
        for (Entity e : Levels.getLevel().getEntities()) {
            if (!bounds.intersects(e.getBounds())) continue;
            if (e.isSolid() && this.action.equals((Object)Action.MOVE)) {
                execute = false;
                break;
            }
            if (e.getChildId() <= 0 || !this.action.equals((Object)Action.INTERACT)) continue;
            Global.setInterface(new Option_Interface(e.getChildId()));
            this.canMove = true;
            break;
        }
        if (this.action.equals((Object)Action.MOVE)) {
            if (Dx >= Board.B_DIMENSION || Dy >= Board.B_DIMENSION) {
                execute = false;
            }
            if (Dx < 0 || Dy < 0) {
                execute = false;
            }
        }
        if (execute && this.action.equals((Object)Action.MOVE)) {
            super.move();
        }
        this.refresh();
    }

    private static enum Action {
        INTERACT,
        MOVE,
        IDLE;

    }

    private static enum Facing {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

