/*
 * Decompiled with CFR 0.152.
 */
package main.controllers;

import java.awt.Image;
import java.awt.event.KeyEvent;
import main.Global;
import main.Utilities;
import main.controllers.Controller;
import main.entities.Entity;
import main.interfaces.Editor_Interface;
import main.levels.Level_Handler;
import main.levels.Levels;

public class Editor
extends Controller {
    public Editor(int x, int y, Image image) {
        super(x, y, image);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                super.setDx(-Global.TILE_OFFSET);
                break;
            }
            case 39: {
                super.setDx(Global.TILE_OFFSET);
                break;
            }
            case 38: {
                super.setDy(-Global.TILE_OFFSET);
                break;
            }
            case 40: {
                super.setDy(Global.TILE_OFFSET);
                break;
            }
            case 120: {
                Levels.setLevel(100);
                break;
            }
            default: {
                this.submitEditor(e, super.getX(), super.getY());
            }
        }
        this.move();
        super.setDx(0);
        super.setDy(0);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void submitEditor(KeyEvent e, int x, int y) {
        switch (e.getKeyCode()) {
            case 127: {
                int arrayLocation = -1;
                for (int i = 0; i < Levels.getLevel().getEntities().size(); ++i) {
                    if (Levels.getLevel().getEntities().get(i).getX() != x || Levels.getLevel().getEntities().get(i).getY() != y || i <= arrayLocation) continue;
                    arrayLocation = i;
                }
                if (arrayLocation <= -1) break;
                Levels.getLevel().getEntities().remove(arrayLocation);
                break;
            }
            case 123: {
                Level_Handler.save();
            }
        }
        if (Utilities.isNumericalKey(e.getKeyChar())) {
            this.callEditorInterface(Utilities.convertKey(e.getKeyChar()));
        }
    }

    private void callEditorInterface(int type) {
        for (Entity entity : Levels.getLevel().getEntities()) {
            entity.setVisible(true);
        }
        switch (type) {
            case 1: 
            case 2: {
                Level_Handler.addEntity(type, 0, Global.imageLocation, super.getX(), super.getY());
                break;
            }
            case 3: 
            case 4: {
                Global.setInterface(new Editor_Interface(type));
            }
        }
    }
}

