/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.Timer;
import main.Global;
import main.controllers.Controller;
import main.entities.Entity;
import main.entities.MenuTrack;
import main.inventory.Inventory;
import main.inventory.Slot;
import main.levels.Levels;
import main.resources.Images;

public class Board
extends JPanel
implements ActionListener {
    Timer timer = new Timer(60, this);
    public static int B_DIMENSION = 256;
    private static int[] textLine = new int[]{256, 272, 288, 304};
    private static int[] chatLine = new int[]{270, 286, 302, 318};
    Font chatFont = new Font("Courier New", 0, 11);
    Font inventoryFont = new Font("Courier New", 3, 12);
    Font slotFont = new Font("Courier New", 1, 11);
    Color color1 = new Color(24, 24, 24);
    Color color2 = new Color(12, 12, 12);
    Color menuColor = new Color(24, 24, 24, 128);

    public Board() {
        this.addKeyListener(new TAdapter());
        this.setFocusable(true);
        this.setBackground(Color.BLACK);
        this.setDoubleBuffered(true);
        this.timer.start();
        Levels.setLevel(100);
        Global.resetGlobalText();
        Inventory.initialize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        Controller c = Levels.getLevel().getController();
        switch (Global.getGameState()) {
            case CREDITS: {
                g2d.setColor(Color.WHITE);
                g2d.setFont(this.chatFont);
                g2d.drawImage(c.getImage(), c.getX(), c.getY() - Global.Y_OFFSET, this);
                for (Entity e : Levels.getLevel().getEntities()) {
                    if (!(e instanceof MenuTrack) || ((MenuTrack)e).getLabel() == null) continue;
                    g2d.drawString(((MenuTrack)e).getLabel(), e.getX() + 16, e.getY() + 11);
                }
                g2d.drawString("Game: Cake Quest", 20, 50);
                g2d.drawString("Development: 30 July 14 - 01 November 14", 20, 70);
                g2d.drawString("Website: www.krimsky.net", 20, 90);
                g2d.drawString("Programming: Aleksander Krimsky", 20, 110);
                g2d.drawString("Artwork: Stephen Challener (Redshrike)", 20, 130);
                g2d.drawString("Artwork: Charles Gabriel", 20, 150);
                g2d.drawImage(Images.loadImage("gui/border.png"), 50, 175, this);
                break;
            }
            case MENU: {
                Image bg = Images.loadImage("gui/background.png");
                g2d.drawImage(bg, super.getWidth() / 2 - bg.getWidth(null) / 2, super.getHeight() / 2 - bg.getHeight(null) / 2, this);
                g2d.setColor(this.menuColor);
                g2d.fillRect(114, 86, 110, 150);
                g2d.setColor(Color.WHITE);
                g2d.setFont(this.chatFont);
                g2d.drawImage(c.getImage(), c.getX(), c.getY() - Global.Y_OFFSET, this);
                g2d.drawImage(Images.loadImage("gui/logo.png"), 124, 96, this);
                for (Entity e : Levels.getLevel().getEntities()) {
                    if (!(e instanceof MenuTrack) || ((MenuTrack)e).getLabel() == null) continue;
                    g2d.drawString(((MenuTrack)e).getLabel(), e.getX() + 16, e.getY() + 11);
                }
                g2d.drawString("Action <Z>", 5, super.getHeight() - 10);
                g2d.drawString("Version 1.0", super.getWidth() - 80, super.getHeight() - 10);
                break;
            }
            case GAME: {
                int x;
                for (Entity e : Levels.getLevel().getEntities()) {
                    if (e.isVisible()) {
                        g2d.drawImage(e.getImage(), e.getX(), e.getY(), this);
                    }
                    if (!Global.isShowingChild()) continue;
                    g2d.setColor(Color.RED);
                    if (e.getChildId() <= 0) continue;
                    g2d.drawString("" + e.getChildId(), e.getX(), e.getY());
                }
                g2d.drawImage(c.getImage(), c.getX(), c.getY() - Global.Y_OFFSET, this);
                g2d.drawImage(Images.loadImage("gui/logo.png"), 256, 0, this);
                g2d.setColor(Color.WHITE);
                g2d.setFont(this.chatFont);
                g2d.drawString("Aleksander", 265, 70);
                g2d.drawString("Krimsky", 275, 80);
                g2d.drawString("krimsky.net", 263, 90);
                g2d.drawString(Global.getLevelName(), 5, 10);
                if (Global.getGameLevel() != 99) {
                    g2d.setFont(this.slotFont);
                    for (Slot slot : Inventory.getSlots()) {
                        g2d.setColor(this.color1);
                        g2d.fillRect(slot.getX(), slot.getY(), 32, 32);
                        if (slot.getItem() != null) {
                            g2d.setColor(Color.YELLOW);
                            int xOffset = (16 - slot.getImage().getWidth(null)) / 2 + 8;
                            int yOffset = (16 - slot.getImage().getHeight(null)) / 2 + 8;
                            g2d.drawImage(slot.getImage(), slot.getX() + xOffset, slot.getY() + yOffset, this);
                        } else {
                            g2d.setColor(Color.GRAY);
                        }
                        g2d.drawString("Slot " + slot.getId(), 295, slot.getY() + 19);
                    }
                    g.setColor(Color.GRAY);
                    g.drawLine(255, 107, 350, 107);
                    g.drawLine(255, 123, 350, 123);
                    g.drawLine(255, 156, 350, 156);
                    g.drawLine(255, 189, 350, 189);
                    g.drawLine(255, 222, 350, 222);
                    g.drawLine(288, 123, 288, 255);
                    g.setFont(this.inventoryFont);
                    g.drawString("Inventory", 267, 120);
                }
                if (Global.getGameLevel() == 99) {
                    g.setColor(Color.YELLOW);
                    g.drawRect(c.getX(), c.getY(), c.getWidth(), c.getHeight());
                    g2d.drawString("E: " + Levels.getLevel().getEntities().size(), 256, 120);
                    g2d.drawString("Solid    <1>", 256, 135);
                    g2d.drawString("NonSolid <2>", 256, 150);
                    g2d.drawString("SChild   <3>", 256, 165);
                    g2d.drawString("NonChild <4>", 256, 180);
                    g2d.drawString("Delete <Del>", 256, 195);
                    g2d.drawString("Save   <F12>", 256, 210);
                    g2d.drawString("Exit    <F9>", 256, 225);
                }
                for (x = 0; x < 4; ++x) {
                    g2d.setColor((double)x / 2.0 % 1.0 == 0.0 ? this.color1 : this.color2);
                    g2d.fillRect(0, textLine[x], super.getWidth(), 16);
                }
                g.setFont(this.chatFont);
                switch (Global.getFocus()) {
                    case CONTROLLER: {
                        for (x = 0; x < Global.getGlobalText().size() - 1; ++x) {
                            g.setColor(x == 0 ? Color.WHITE : Color.GRAY);
                            g2d.drawString(Global.getGlobalText().get(x), 2, chatLine[x]);
                        }
                        break;
                    }
                    case INTERFACE: {
                        for (x = 0; x < Global.getInterfaceText().size(); ++x) {
                            g.setColor(x == 0 ? Color.YELLOW : Color.WHITE);
                            g2d.drawString((x != 0 ? "   " : "") + Global.getInterfaceText().get(x), 2, chatLine[x]);
                        }
                        break;
                    }
                }
                g.setColor(Color.GRAY);
                g.drawLine(255, 0, 255, 255);
                g.drawLine(0, 255, 350, 255);
                g.drawLine(0, 321, 350, 321);
            }
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    private class TAdapter
    extends KeyAdapter {
        private TAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (Global.getFocus()) {
                case CONTROLLER: {
                    Levels.getLevel().getController().keyPressed(e);
                    break;
                }
                case INTERFACE: {
                    Global.getInterface().keyPressed(e);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            switch (Global.getFocus()) {
                case CONTROLLER: {
                    Levels.getLevel().getController().keyReleased(e);
                }
            }
        }
    }
}

